import { defineComponent, mergeModels, useModel, ref, computed, openBlock, createElementBlock, unref, normalizeClass } from "vue";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { n as normalizeInput, u as useFormInput } from "./useFormInput-B-34kU2d.mjs";
import { u as useStateClass } from "./useStateClass-BGbSLWFN.mjs";
const _hoisted_1 = ["id", "value", "name", "form", "type", "disabled", "placeholder", "required", "autocomplete", "readonly", "min", "max", "step", "list", "aria-required", "aria-invalid"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormInput",
  props: /* @__PURE__ */ mergeModels({
    max: { default: void 0 },
    min: { default: void 0 },
    step: { default: void 0 },
    type: { default: "text" },
    ariaInvalid: { type: [Boolean, String], default: void 0 },
    autocomplete: { default: void 0 },
    autofocus: { type: Boolean, default: false },
    disabled: { type: Boolean, default: false },
    form: { default: void 0 },
    formatter: { type: Function, default: void 0 },
    id: { default: void 0 },
    lazyFormatter: { type: Boolean, default: false },
    list: { default: void 0 },
    name: { default: void 0 },
    placeholder: { default: void 0 },
    plaintext: { type: Boolean, default: false },
    readonly: { type: Boolean, default: false },
    required: { type: Boolean, default: false },
    size: { default: void 0 },
    state: { type: [Boolean, null], default: null },
    debounce: { default: 0 },
    debounceMaxWait: { default: NaN }
  }, {
    "modelValue": {
      default: ""
    },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BFormInput");
    const [modelValue, modelModifiers] = useModel(__props, "modelValue", {
      set: (v) => normalizeInput(v, modelModifiers)
    });
    const { input, computedId, computedAriaInvalid, onInput, onChange, onBlur, focus, blur } = useFormInput(props, modelValue, modelModifiers);
    const stateClass = useStateClass(() => props.state);
    const isHighlighted = ref(false);
    const computedClasses = computed(() => {
      const isRange = props.type === "range";
      const isColor = props.type === "color";
      return [
        stateClass.value,
        {
          "form-control-highlighted": isHighlighted.value,
          "form-range": isRange,
          "form-control": isColor || !props.plaintext && !isRange,
          "form-control-color": isColor,
          "form-control-plaintext": props.plaintext && !isRange && !isColor,
          [`form-control-${props.size}`]: !!props.size
        }
      ];
    });
    __expose({
      blur,
      element: input,
      focus
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("input", {
        id: unref(computedId),
        ref_key: "input",
        ref: input,
        value: unref(modelValue),
        class: normalizeClass(computedClasses.value),
        name: unref(props).name || void 0,
        form: unref(props).form || void 0,
        type: unref(props).type,
        disabled: unref(props).disabled,
        placeholder: unref(props).placeholder,
        required: unref(props).required || void 0,
        autocomplete: unref(props).autocomplete || void 0,
        readonly: unref(props).readonly || unref(props).plaintext,
        min: unref(props).min,
        max: unref(props).max,
        step: unref(props).step,
        list: unref(props).type !== "password" ? unref(props).list : void 0,
        "aria-required": unref(props).required || void 0,
        "aria-invalid": unref(computedAriaInvalid),
        onInput: _cache[0] || (_cache[0] = ($event) => unref(onInput)($event)),
        onChange: _cache[1] || (_cache[1] = ($event) => unref(onChange)($event)),
        onBlur: _cache[2] || (_cache[2] = ($event) => unref(onBlur)($event))
      }, null, 42, _hoisted_1);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BFormInput.vue_vue_type_script_setup_true_lang-Cff0bCQa.mjs.map
