import { defineComponent, computed, openBlock, createElementBlock, unref, renderSlot, Fragment, renderList, createBlock, mergeProps, withCtx, createTextVNode, toDisplayString, mergeModels, useModel, ref, withDirectives, normalizeClass, vModelSelect } from "vue";
import { u as useFormSelect, _ as _sfc_main$2 } from "./useFormSelect-C5Ssz8Hc.mjs";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { u as useAriaInvalid } from "./useAriaInvalid-BTUbGj3Y.mjs";
import { e as useFocus } from "./index-DngH9Pjm.mjs";
import { u as useId } from "./useId-BrAgQfKM.mjs";
import { u as useStateClass } from "./useStateClass-BGbSLWFN.mjs";
import { u as useToNumber } from "./index-DlGgXMQF.mjs";
const _hoisted_1$1 = ["label"];
const _hoisted_2$1 = ["innerHTML"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BFormSelectOptionGroup",
  props: {
    disabledField: { default: "disabled" },
    htmlField: { default: "html" },
    label: { default: void 0 },
    options: { default: () => [] },
    textField: { default: "text" },
    valueField: { default: "value" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BFormSelectOptionGroup");
    const { normalizedOptions } = useFormSelect(() => props.options, props);
    const normalizedOptsWrapper = computed(() => normalizedOptions.value);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("optgroup", {
        label: unref(props).label
      }, [
        renderSlot(_ctx.$slots, "first"),
        (openBlock(true), createElementBlock(Fragment, null, renderList(normalizedOptsWrapper.value, (option, index) => {
          return openBlock(), createBlock(_sfc_main$2, mergeProps({
            key: index,
            disabled: option.disabled,
            value: option.value,
            ref_for: true
          }, _ctx.$attrs), {
            default: withCtx(() => [
              !!option.html ? (openBlock(), createElementBlock("span", {
                key: 0,
                innerHTML: option.html
              }, null, 8, _hoisted_2$1)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                createTextVNode(toDisplayString(option.text), 1)
              ], 64))
            ]),
            _: 2
          }, 1040, ["disabled", "value"]);
        }), 128)),
        renderSlot(_ctx.$slots, "default")
      ], 8, _hoisted_1$1);
    };
  }
});
const _hoisted_1 = ["id", "name", "form", "multiple", "size", "disabled", "required", "aria-required", "aria-invalid"];
const _hoisted_2 = ["innerHTML"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormSelect",
  props: /* @__PURE__ */ mergeModels({
    ariaInvalid: { type: [Boolean, String], default: void 0 },
    autofocus: { type: Boolean, default: false },
    disabled: { type: Boolean, default: false },
    disabledField: { default: "disabled" },
    form: { default: void 0 },
    htmlField: { default: "html" },
    id: { default: void 0 },
    labelField: { default: "label" },
    multiple: { type: Boolean, default: false },
    name: { default: void 0 },
    options: { default: () => [] },
    optionsField: { default: "options" },
    plain: { type: Boolean, default: false },
    required: { type: Boolean, default: false },
    selectSize: { default: 0 },
    size: { default: "md" },
    state: { type: [Boolean, null], default: null },
    textField: { default: "text" },
    valueField: { default: "value" }
  }, {
    "modelValue": {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      default: ""
    },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BFormSelect");
    const modelValue = useModel(__props, "modelValue");
    const computedId = useId(() => props.id, "input");
    const selectSizeNumber = useToNumber(() => props.selectSize);
    const stateClass = useStateClass(() => props.state);
    const input = ref(null);
    const { focused } = useFocus(input, {
      initialValue: props.autofocus
    });
    const computedClasses = computed(() => [
      stateClass.value,
      {
        "form-control": props.plain,
        [`form-control-${props.size}`]: props.size !== "md" && props.plain,
        "form-select": !props.plain,
        [`form-select-${props.size}`]: props.size !== "md" && !props.plain
      }
    ]);
    const computedSelectSize = computed(
      () => selectSizeNumber.value || props.plain ? selectSizeNumber.value : void 0
    );
    const computedAriaInvalid = useAriaInvalid(
      () => props.ariaInvalid,
      () => props.state
    );
    const { normalizedOptions, isComplex } = useFormSelect(() => props.options, props);
    const normalizedOptsWrapper = computed(
      () => normalizedOptions.value
    );
    const localValue = computed({
      get: () => modelValue.value,
      set: (newValue) => {
        modelValue.value = newValue;
      }
    });
    __expose({
      blur: () => {
        focused.value = false;
      },
      element: input,
      focus: () => {
        focused.value = true;
      }
    });
    return (_ctx, _cache) => {
      return withDirectives((openBlock(), createElementBlock("select", {
        id: unref(computedId),
        ref_key: "input",
        ref: input,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => localValue.value = $event),
        class: normalizeClass(computedClasses.value),
        name: unref(props).name,
        form: unref(props).form || void 0,
        multiple: unref(props).multiple || void 0,
        size: computedSelectSize.value,
        disabled: unref(props).disabled,
        required: unref(props).required || void 0,
        "aria-required": unref(props).required || void 0,
        "aria-invalid": unref(computedAriaInvalid)
      }, [
        renderSlot(_ctx.$slots, "first"),
        (openBlock(true), createElementBlock(Fragment, null, renderList(normalizedOptsWrapper.value, (option, index) => {
          return openBlock(), createElementBlock(Fragment, { key: index }, [
            unref(isComplex)(option) ? (openBlock(), createBlock(_sfc_main$1, {
              key: 0,
              label: option.label,
              options: option.options,
              "value-field": unref(props).valueField,
              "text-field": unref(props).textField,
              "html-field": unref(props).htmlField,
              "disabled-field": unref(props).disabledField
            }, null, 8, ["label", "options", "value-field", "text-field", "html-field", "disabled-field"])) : (openBlock(), createBlock(_sfc_main$2, {
              key: 1,
              value: option.value,
              disabled: option.disabled
            }, {
              default: withCtx(() => [
                !!option.html ? (openBlock(), createElementBlock("span", {
                  key: 0,
                  innerHTML: option.html
                }, null, 8, _hoisted_2)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                  createTextVNode(toDisplayString(option.text), 1)
                ], 64))
              ]),
              _: 2
            }, 1032, ["value", "disabled"]))
          ], 64);
        }), 128)),
        renderSlot(_ctx.$slots, "default")
      ], 10, _hoisted_1)), [
        [vModelSelect, localValue.value]
      ]);
    };
  }
});
export {
  _sfc_main as _,
  _sfc_main$1 as a
};
//# sourceMappingURL=BFormSelect.vue_vue_type_script_setup_true_lang-DomR7pgn.mjs.map
