import { defineComponent, computed, openBlock, createBlock, resolveDynamicComponent, unref, normalizeClass, withCtx, renderSlot, createTextVNode, toDisplayString } from "vue";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "BFormInvalidFeedback",
  props: {
    ariaLive: { default: void 0 },
    forceShow: { type: Boolean, default: false },
    id: { default: void 0 },
    role: { default: void 0 },
    state: { type: [Boolean, null], default: null },
    tag: { default: "div" },
    text: { default: void 0 },
    tooltip: { type: Boolean, default: false }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BFormInvalidFeedback");
    const computedShow = computed(() => props.forceShow === true || props.state === false);
    const computedClasses = computed(() => ({
      "d-block": computedShow.value,
      "invalid-feedback": !props.tooltip,
      "invalid-tooltip": props.tooltip
    }));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        id: unref(props).id,
        role: unref(props).role,
        "aria-live": unref(props).ariaLive,
        "aria-atomic": unref(props).ariaLive ? true : void 0,
        class: normalizeClass(computedClasses.value)
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(unref(props).text), 1)
          ])
        ]),
        _: 3
      }, 8, ["id", "role", "aria-live", "aria-atomic", "class"]);
    };
  }
});
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "BFormRow",
  props: {
    tag: { default: "div" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BFormRow");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), { class: "row d-flex flex-wrap" }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      });
    };
  }
});
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BFormText",
  props: {
    id: { default: void 0 },
    inline: { type: Boolean, default: false },
    tag: { default: "small" },
    text: { default: void 0 },
    textVariant: { default: "body-secondary" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BFormText");
    const computedClasses = computed(() => ({
      [`text-${props.textVariant}`]: props.textVariant !== null,
      "form-text": !props.inline
    }));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        id: unref(props).id,
        class: normalizeClass(computedClasses.value)
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(unref(props).text), 1)
          ])
        ]),
        _: 3
      }, 8, ["id", "class"]);
    };
  }
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormValidFeedback",
  props: {
    ariaLive: { default: void 0 },
    forceShow: { type: Boolean, default: false },
    id: { default: void 0 },
    role: { default: void 0 },
    state: { type: [Boolean, null], default: null },
    tag: { default: "div" },
    text: { default: void 0 },
    tooltip: { type: Boolean, default: false }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BFormInvalidFeedback");
    const computedShow = computed(() => props.forceShow === true || props.state === true);
    const computedClasses = computed(() => ({
      "d-block": computedShow.value,
      "valid-feedback": !props.tooltip,
      "valid-tooltip": props.tooltip
    }));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        id: unref(props).id,
        role: unref(props).role,
        "aria-live": unref(props).ariaLive,
        "aria-atomic": unref(props).ariaLive ? true : void 0,
        class: normalizeClass(computedClasses.value)
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(unref(props).text), 1)
          ])
        ]),
        _: 3
      }, 8, ["id", "role", "aria-live", "aria-atomic", "class"]);
    };
  }
});
export {
  _sfc_main$3 as _,
  _sfc_main$2 as a,
  _sfc_main$1 as b,
  _sfc_main as c
};
//# sourceMappingURL=BFormValidFeedback.vue_vue_type_script_setup_true_lang-DSA6Ix_l.mjs.map
