import { computed, toValue, defineComponent, useAttrs, inject, getCurrentInstance, openBlock, createBlock, resolveDynamicComponent, mergeProps, withCtx, unref, renderSlot } from "vue";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { c as collapseInjectionKey, n as navbarInjectionKey } from "./keys-CLEaYsGj.mjs";
const useLinkClasses = (linkProps) => computed(() => {
  const props = toValue(linkProps);
  return {
    [`link-${props.variant}`]: props.variant !== null,
    [`link-opacity-${props.opacity}`]: props.opacity !== void 0,
    [`link-opacity-${props.opacityHover}-hover`]: props.opacityHover !== void 0,
    [`link-underline-${props.underlineVariant}`]: props.underlineVariant !== null,
    [`link-offset-${props.underlineOffset}`]: props.underlineOffset !== void 0,
    [`link-offset-${props.underlineOffsetHover}-hover`]: props.underlineOffsetHover !== void 0,
    ["link-underline"]: props.underlineVariant === null && (props.underlineOpacity !== void 0 || props.underlineOpacityHover !== void 0),
    [`link-underline-opacity-${props.underlineOpacity}`]: props.underlineOpacity !== void 0,
    [`link-underline-opacity-${props.underlineOpacityHover}-hover`]: props.underlineOpacityHover !== void 0,
    "icon-link": props.icon === true
  };
});
const defaultActiveClass = "active";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BLink",
  props: {
    active: { type: Boolean, default: void 0 },
    activeClass: { default: "router-link-active" },
    disabled: { type: Boolean, default: false },
    exactActiveClass: { default: "router-link-exact-active" },
    href: { default: void 0 },
    icon: { type: Boolean, default: false },
    noRel: { type: Boolean },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    rel: { default: void 0 },
    replace: { type: Boolean, default: false },
    routerComponentName: { default: "router-link" },
    routerTag: { default: "a" },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: null },
    variant: { default: null }
  },
  emits: ["click"],
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BLink");
    const emit = __emit;
    const attrs = useAttrs();
    const collapseData = inject(collapseInjectionKey, null);
    const navbarData = inject(navbarInjectionKey, null);
    const instance = getCurrentInstance();
    const tag = computed(() => {
      const routerName = props.routerComponentName.split("-").map((e) => e.charAt(0).toUpperCase() + e.slice(1)).join("");
      const hasRouter = (instance == null ? void 0 : instance.appContext.app.component(routerName)) !== void 0;
      if (!hasRouter || props.disabled || !props.to) {
        return "a";
      }
      return props.routerComponentName;
    });
    const computedHref = computed(() => {
      const toFallback = "#";
      if (props.href) return props.href;
      if (typeof props.to === "string") return props.to || toFallback;
      const { to } = props;
      if (to !== void 0 && "path" in to) {
        const path = to.path || "";
        const query = to.query ? `?${Object.keys(to.query).map((e) => {
          var _a;
          return `${e}=${(_a = to.query) == null ? void 0 : _a[e]}`;
        }).join("=")}` : "";
        const hash = !to.hash || to.hash.charAt(0) === "#" ? to.hash || "" : `#${to.hash}`;
        return `${path}${query}${hash}` || toFallback;
      }
      return toFallback;
    });
    const linkValueClasses = useLinkClasses(props);
    const computedClasses = computed(() => [
      linkValueClasses.value,
      {
        "stretched-link": props.stretched === true
      }
    ]);
    const routerAttr = computed(() => ({
      "class": computedClasses.value,
      "to": props.to,
      "replace": props.replace,
      "href": computedHref.value,
      "target": props.target,
      "rel": props.target === "_blank" ? props.rel ?? "noopener" : void 0,
      "tabindex": props.disabled ? "-1" : typeof attrs.tabindex === "undefined" ? null : attrs.tabindex,
      "aria-disabled": props.disabled ? true : null
    }));
    const computedLinkClasses = computed(() => ({
      [defaultActiveClass]: props.active,
      disabled: props.disabled
    }));
    const clicked = (e) => {
      var _a, _b, _c;
      if (props.disabled) {
        e.preventDefault();
        e.stopImmediatePropagation();
        return;
      }
      if (((_a = collapseData == null ? void 0 : collapseData.isNav) == null ? void 0 : _a.value) === true && navbarData === null || navbarData !== null && ((_b = navbarData.autoClose) == null ? void 0 : _b.value) === true) {
        (_c = collapseData == null ? void 0 : collapseData.hide) == null ? void 0 : _c.call(collapseData);
      }
      emit("click", e);
    };
    return (_ctx, _cache) => {
      return tag.value === "router-link" ? (openBlock(), createBlock(resolveDynamicComponent(tag.value), mergeProps({ key: 0 }, routerAttr.value, { custom: "" }), {
        default: withCtx(({ href: localHref, navigate, isActive, isExactActive }) => [
          (openBlock(), createBlock(resolveDynamicComponent(unref(props).routerTag), mergeProps({
            href: localHref,
            target: unref(props).target,
            class: {
              [defaultActiveClass]: unref(props).active,
              [unref(props).activeClass]: isActive,
              [unref(props).exactActiveClass]: isExactActive
            }
          }, _ctx.$attrs, {
            onClick: ($event) => {
              [navigate($event), clicked($event)];
            }
          }), {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            _: 2
          }, 1040, ["href", "target", "class", "onClick"]))
        ]),
        _: 3
      }, 16)) : (openBlock(), createBlock(resolveDynamicComponent(tag.value), mergeProps({
        key: 1,
        class: computedLinkClasses.value
      }, routerAttr.value, { onClick: clicked }), {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 16, ["class"]));
    };
  }
});
export {
  _sfc_main as _,
  useLinkClasses as u
};
//# sourceMappingURL=BLink.vue_vue_type_script_setup_true_lang-C39-ereM.mjs.map
