import { defineComponent, computed, openBlock, createBlock, unref, withCtx, renderSlot, createVNode, resolveDynamicComponent, normalizeClass, normalizeStyle, createElementVNode, normalizeProps, guardReactiveProps, mergeProps, createCommentVNode } from "vue";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { _ as _sfc_main$2 } from "./BTransition.vue_vue_type_style_index_0_lang-X5a8jq3A.mjs";
import { _ as _sfc_main$3 } from "./BSpinner.vue_vue_type_script_setup_true_lang-Bi3Ic2-3.mjs";
import { _ as _sfc_main$1 } from "./ConditionalWrapper.vue_vue_type_script_lang-B-0cSyYg.mjs";
import { u as useRadiusElementClasses } from "./useRadiusElementClasses-DtKYQuWz.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BOverlay",
  props: {
    bgColor: { default: void 0 },
    blur: { default: "2px" },
    fixed: { type: Boolean, default: false },
    noCenter: { type: Boolean, default: false },
    noFade: { type: Boolean, default: false },
    noSpinner: { type: Boolean, default: false },
    noWrap: { type: Boolean, default: false },
    opacity: { default: 0.85 },
    overlayTag: { default: "div" },
    show: { type: Boolean, default: false },
    spinnerSmall: { type: Boolean, default: false },
    spinnerType: { default: "border" },
    spinnerVariant: { default: void 0 },
    variant: { default: "light" },
    wrapTag: { default: "div" },
    zIndex: { default: 10 },
    rounded: { type: [Boolean, String, Number], default: false },
    roundedTop: { type: [Boolean, String, Number], default: void 0 },
    roundedBottom: { type: [Boolean, String, Number], default: void 0 },
    roundedStart: { type: [Boolean, String, Number], default: void 0 },
    roundedEnd: { type: [Boolean, String, Number], default: void 0 }
  },
  emits: ["click", "hidden", "shown"],
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BOverlay");
    const emit = __emit;
    const positionStyles = { top: 0, left: 0, bottom: 0, right: 0 };
    const radiusElementClasses = useRadiusElementClasses(() => ({
      rounded: props.rounded,
      roundedTop: props.roundedTop,
      roundedBottom: props.roundedBottom,
      roundedStart: props.roundedStart,
      roundedEnd: props.roundedEnd
    }));
    const computedVariant = computed(
      () => props.variant !== null && !props.bgColor ? `bg-${props.variant}` : ""
    );
    const computedAriaBusy = computed(() => props.show ? true : null);
    const spinnerAttrs = computed(() => ({
      type: props.spinnerType,
      variant: props.spinnerVariant,
      small: props.spinnerSmall
    }));
    const overlayStyles = computed(() => ({
      ...positionStyles,
      zIndex: props.zIndex || 10
    }));
    const overlayClasses = computed(() => ({
      "position-absolute": !props.noWrap || !props.fixed,
      "position-fixed": props.noWrap && props.fixed
    }));
    const blurClasses = computed(() => [computedVariant.value, radiusElementClasses.value]);
    const blurStyles = computed(() => ({
      ...positionStyles,
      opacity: props.opacity,
      backgroundColor: props.bgColor || void 0,
      backdropFilter: props.blur ? `blur(${props.blur})` : void 0
    }));
    const spinWrapperStyles = computed(
      () => props.noCenter ? positionStyles : {
        top: "50%",
        left: "50%",
        transform: "translateX(-50%) translateY(-50%)"
      }
    );
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$1, {
        tag: unref(props).wrapTag,
        class: "b-overlay-wrap position-relative",
        "aria-busy": computedAriaBusy.value,
        skip: unref(props).noWrap
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default"),
          createVNode(_sfc_main$2, {
            "no-fade": unref(props).noFade,
            "trans-props": { enterToClass: "show" },
            name: "fade",
            onAfterEnter: _cache[1] || (_cache[1] = ($event) => emit("shown")),
            onAfterLeave: _cache[2] || (_cache[2] = ($event) => emit("hidden"))
          }, {
            default: withCtx(() => [
              unref(props).show ? (openBlock(), createBlock(resolveDynamicComponent(unref(props).overlayTag), {
                key: 0,
                class: normalizeClass(["b-overlay", overlayClasses.value]),
                style: normalizeStyle(overlayStyles.value),
                onClick: _cache[0] || (_cache[0] = ($event) => emit("click", $event))
              }, {
                default: withCtx(() => [
                  createElementVNode("div", {
                    class: normalizeClass(["position-absolute", blurClasses.value]),
                    style: normalizeStyle(blurStyles.value)
                  }, null, 6),
                  createElementVNode("div", {
                    class: "position-absolute",
                    style: normalizeStyle(spinWrapperStyles.value)
                  }, [
                    renderSlot(_ctx.$slots, "overlay", normalizeProps(guardReactiveProps(spinnerAttrs.value)), () => [
                      !unref(props).noSpinner ? (openBlock(), createBlock(_sfc_main$3, normalizeProps(mergeProps({ key: 0 }, spinnerAttrs.value)), null, 16)) : createCommentVNode("", true)
                    ])
                  ], 4)
                ]),
                _: 3
              }, 8, ["class", "style"])) : createCommentVNode("", true)
            ]),
            _: 3
          }, 8, ["no-fade"])
        ]),
        _: 3
      }, 8, ["tag", "aria-busy", "skip"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BOverlay.vue_vue_type_script_setup_true_lang-BxDX9fPu.mjs.map
