import { defineComponent, mergeModels, useSlots, useModel, inject, ref, useAttrs, computed, onMounted, onUnmounted, watch, openBlock, createBlock, resolveDynamicComponent, unref, mergeProps, withCtx, renderSlot, createCommentVNode, nextTick, provide, toRef, normalizeClass, createVNode, createElementVNode, createElementBlock, Fragment, renderList, withKeys, withModifiers, createTextVNode, toDisplayString } from "vue";
import { u as useId } from "./useId-BrAgQfKM.mjs";
import { u as useDefaults } from "./useDefaults-BYx9NNxn.mjs";
import { q as tabsInjectionKey } from "./keys-CLEaYsGj.mjs";
import { B as BvEvent } from "./classes-IC0yVJlq.mjs";
import { u as useAlignment } from "./useAlignment-Cw-9AVid.mjs";
import { j as createReusableTemplate } from "./index-DngH9Pjm.mjs";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BTab",
  props: /* @__PURE__ */ mergeModels({
    buttonId: { default: void 0 },
    disabled: { type: Boolean, default: false },
    id: { default: void 0 },
    lazy: { type: Boolean, default: void 0 },
    lazyOnce: { type: Boolean, default: void 0 },
    noBody: { type: Boolean, default: false },
    tag: { default: "div" },
    title: { default: void 0 },
    titleItemClass: { default: void 0 },
    titleLinkAttrs: { default: void 0 },
    titleLinkClass: { default: void 0 }
  }, {
    "active": { type: Boolean, ...{
      default: false
    } },
    "activeModifiers": {}
  }),
  emits: ["update:active"],
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BTab");
    const slots = useSlots();
    const activeModel = useModel(__props, "active");
    const parentData = inject(tabsInjectionKey, null);
    const computedId = useId(() => props.id, "tabpane");
    const computedButtonId = useId(() => props.buttonId, "tab");
    const lazyRenderCompleted = ref(false);
    const el = ref(null);
    const { onClick, ...attrs } = useAttrs();
    const tab = computed(
      () => ({
        id: computedId.value,
        buttonId: computedButtonId.value,
        disabled: props.disabled,
        title: props.title,
        titleComponent: slots.title,
        titleItemClass: () => props.titleItemClass,
        titleLinkAttrs: () => props.titleLinkAttrs,
        titleLinkClass: () => props.titleLinkClass,
        onClick,
        el: el.value
      })
    );
    onMounted(() => {
      if (!parentData) return;
      parentData.registerTab(tab);
      if (activeModel.value) {
        parentData.activateTab(computedId.value);
      }
    });
    onUnmounted(() => {
      if (!parentData) return;
      parentData.unregisterTab(computedId.value);
    });
    const isActive = computed(() => (parentData == null ? void 0 : parentData.activeId.value) === computedId.value);
    const show = ref(isActive.value);
    const computedLazy = computed(() => !!((parentData == null ? void 0 : parentData.lazy.value) || (props.lazyOnce ?? props.lazy)));
    const computedLazyOnce = computed(() => props.lazyOnce !== void 0);
    const computedActive = computed(() => isActive.value && !props.disabled);
    const showSlot = computed(
      () => computedActive.value || !computedLazy.value || computedLazy.value && computedLazyOnce.value && lazyRenderCompleted.value
    );
    watch(isActive, (active) => {
      if (active) {
        activeModel.value = true;
        setTimeout(() => {
          show.value = true;
        }, 0);
        return;
      }
      show.value = false;
      activeModel.value = false;
    });
    watch(activeModel, (active) => {
      if (!parentData) return;
      if (!active) {
        if (isActive.value) {
          parentData.activateTab(void 0);
        }
        return;
      }
      parentData.activateTab(computedId.value);
    });
    const computedClasses = computed(() => [
      {
        "active": isActive.value,
        "show": show.value,
        "card-body": (parentData == null ? void 0 : parentData.card.value) && props.noBody === false,
        "fade": !(parentData == null ? void 0 : parentData.noFade.value)
      },
      show.value ? parentData == null ? void 0 : parentData.activeTabClass.value : parentData == null ? void 0 : parentData.inactiveTabClass.value,
      parentData == null ? void 0 : parentData.tabClass.value
    ]);
    watch(showSlot, (shown) => {
      if (shown && !lazyRenderCompleted.value) lazyRenderCompleted.value = true;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), mergeProps({
        id: unref(computedId),
        ref_key: "el",
        ref: el,
        class: ["tab-pane", computedClasses.value],
        role: "tabpanel",
        "aria-labelledby": unref(computedButtonId)
      }, attrs), {
        default: withCtx(() => [
          showSlot.value ? renderSlot(_ctx.$slots, "default", { key: 0 }) : createCommentVNode("", true)
        ]),
        _: 3
      }, 16, ["id", "class", "aria-labelledby"]);
    };
  }
});
const _hoisted_1 = ["aria-orientation"];
const _hoisted_2 = ["id", "aria-controls", "aria-selected", "onClick"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BTabs",
  props: /* @__PURE__ */ mergeModels({
    activeNavItemClass: { default: void 0 },
    activeTabClass: { default: void 0 },
    align: { default: void 0 },
    card: { type: Boolean, default: false },
    contentClass: { default: void 0 },
    end: { type: Boolean, default: false },
    fill: { type: Boolean, default: false },
    id: { default: void 0 },
    inactiveNavItemClass: { default: void 0 },
    inactiveTabClass: { default: void 0 },
    justified: { type: Boolean, default: false },
    lazy: { type: Boolean, default: false },
    navClass: { default: void 0 },
    navItemClass: { default: void 0 },
    navWrapperClass: { default: void 0 },
    noFade: { type: Boolean, default: false },
    noNavStyle: { type: Boolean, default: false },
    pills: { type: Boolean, default: false },
    small: { type: Boolean, default: false },
    tag: { default: "div" },
    tabClass: { default: void 0 },
    vertical: { type: Boolean, default: false }
  }, {
    "modelValue": {
      default: -1
    },
    "modelModifiers": {},
    "activeId": {
      default: void 0
    },
    "activeIdModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["activate-tab", "click"], ["update:modelValue", "update:activeId"]),
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BTabs");
    const emit = __emit;
    const modelValue = useModel(__props, "modelValue");
    const activeId = useModel(__props, "activeId");
    const ReusableEmptyTab = createReusableTemplate();
    const tabsInternal = ref([]);
    const tabs = computed(
      () => tabsInternal.value.map((_tab) => {
        const tab = unref(_tab);
        const active = tab.id === activeId.value;
        return {
          ...tab,
          active,
          navItemClasses: [
            {
              active,
              disabled: tab.disabled
            },
            active ? props.activeNavItemClass : props.inactiveNavItemClass,
            props.navItemClass
          ]
        };
      })
    );
    const showEmpty = computed(() => !((tabs == null ? void 0 : tabs.value) && tabs.value.length > 0));
    const computedClasses = computed(() => ({
      "d-flex": props.vertical,
      "align-items-start": props.vertical
    }));
    const alignment = useAlignment(() => props.align);
    const navTabsClasses = computed(() => ({
      "nav-pills": props.pills,
      "flex-column me-3": props.vertical,
      [alignment.value]: props.align !== void 0,
      "nav-fill": props.fill,
      "card-header-tabs": props.card,
      "nav-justified": props.justified,
      "nav-tabs": !props.noNavStyle && !props.pills,
      "small": props.small
    }));
    const activateTab = (index) => {
      var _a;
      if (index !== void 0) {
        const id = (_a = tabs.value[index]) == null ? void 0 : _a.id;
        if (index > -1 && index < tabs.value.length && !tabs.value[index].disabled && (modelValue.value < 0 || activeId.value !== id || modelValue.value !== index)) {
          const tabEvent = new BvEvent("activate-tab", { cancelable: true });
          emit("activate-tab", index, modelValue.value, tabEvent);
          if (!tabEvent.defaultPrevented) {
            if (activeId.value !== id) activeId.value = id;
            if (modelValue.value !== index) modelValue.value = index;
          }
        }
      }
    };
    const handleClick = (event, index) => {
      var _a, _b, _c;
      activateTab(index);
      if (index >= 0 && !tabs.value[index].disabled && ((_a = tabs.value[index]) == null ? void 0 : _a.onClick) && typeof tabs.value[index].onClick === "function") {
        (_c = (_b = tabs.value[index]).onClick) == null ? void 0 : _c.call(_b, event);
      }
    };
    const keynav = (direction) => {
      var _a, _b;
      if (tabs.value.length <= 0) return;
      modelValue.value = nextIndex(modelValue.value + direction, direction);
      (_b = document.getElementById((_a = tabs.value[modelValue.value]) == null ? void 0 : _a.buttonId)) == null ? void 0 : _b.focus();
    };
    const nextIndex = (start, direction) => {
      let index = start;
      let minIdx = -1;
      let maxIdx = -1;
      for (let i = 0; i < tabs.value.length; i++) {
        if (!tabs.value[i].disabled) {
          if (minIdx === -1) minIdx = i;
          maxIdx = i;
        }
      }
      while (index >= minIdx && index <= maxIdx && tabs.value[index].disabled) {
        index += direction;
      }
      if (index < minIdx) index = minIdx;
      if (index > maxIdx) index = maxIdx;
      return index;
    };
    watch(modelValue, (newValue, oldValue) => {
      if (newValue === oldValue) return;
      if (tabs.value.length <= 0) {
        return;
      }
      const index = nextIndex(newValue, newValue > oldValue ? 1 : -1);
      nextTick(() => {
        activateTab(index);
      });
    });
    watch(activeId, (newValue, oldValue) => {
      const index = tabs.value.findIndex((t) => t.id === newValue);
      if (newValue === oldValue) return;
      if (tabs.value.length <= 0) {
        return;
      }
      if (index === -1) {
        activateTab(nextIndex(0, 1));
        return;
      }
      activateTab(index);
    });
    const registerTab = (tab) => {
      if (!tabsInternal.value.find((t) => t.value.id === tab.value.id)) {
        tabsInternal.value.push(tab);
      } else {
        tabsInternal.value[tabsInternal.value.findIndex((t) => t.value.id === tab.value.id)] = tab;
      }
      tabsInternal.value.sort((a, b) => {
        if (!Node || !a.value.el || !b.value.el) return 0;
        const position = a.value.el.compareDocumentPosition(b.value.el);
        if (position & Node.DOCUMENT_POSITION_FOLLOWING) return -1;
        if (position & Node.DOCUMENT_POSITION_PRECEDING) return 1;
        return 0;
      });
    };
    const unregisterTab = (id) => {
      tabsInternal.value = tabsInternal.value.filter((t) => t.value.id !== id);
    };
    watch(
      tabsInternal,
      () => {
        findActive();
      },
      { deep: true }
    );
    const findActive = () => {
      var _a;
      if (tabs.value.length === 0) {
        modelValue.value = -1;
        activeId.value = void 0;
        return;
      }
      if (modelValue.value >= 0 && !activeId.value) {
        activeId.value = (_a = tabs.value[modelValue.value]) == null ? void 0 : _a.id;
      }
      if (tabs.value.find((t) => t.id === activeId.value)) {
        activateTab(tabs.value.findIndex((t) => t.id === activeId.value));
        return;
      }
      activateTab(tabs.value.map((tab) => !tab.disabled).indexOf(true));
    };
    provide(tabsInjectionKey, {
      lazy: toRef(() => props.lazy),
      card: toRef(() => props.card),
      noFade: toRef(() => props.noFade),
      activeTabClass: toRef(() => props.activeTabClass),
      inactiveTabClass: toRef(() => props.inactiveTabClass),
      tabClass: toRef(() => props.tabClass),
      registerTab,
      unregisterTab,
      activeId,
      activateTab: (id) => {
        const idx = tabs.value.findIndex((t) => t.id === id);
        if (id === void 0 || idx === -1) {
          activateTab(nextIndex(0, 1));
          return;
        }
        activateTab(idx);
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        id: unref(props).id,
        class: normalizeClass(["tabs", computedClasses.value])
      }, {
        default: withCtx(() => [
          createVNode(unref(ReusableEmptyTab).define, null, {
            default: withCtx(() => [
              createElementVNode("div", {
                class: normalizeClass(["tab-content", unref(props).contentClass])
              }, [
                renderSlot(_ctx.$slots, "default"),
                showEmpty.value ? (openBlock(), createElementBlock("div", {
                  key: "bv-empty-tab",
                  class: normalizeClass(["tab-pane active", { "card-body": unref(props).card }])
                }, [
                  renderSlot(_ctx.$slots, "empty")
                ], 2)) : createCommentVNode("", true)
              ], 2)
            ]),
            _: 3
          }),
          unref(props).end ? (openBlock(), createBlock(unref(ReusableEmptyTab).reuse, { key: 0 })) : createCommentVNode("", true),
          createElementVNode("div", {
            class: normalizeClass([
              unref(props).navWrapperClass,
              { "card-header": unref(props).card, "ms-auto": _ctx.vertical && unref(props).end }
            ])
          }, [
            createElementVNode("ul", {
              class: normalizeClass(["nav", [navTabsClasses.value, unref(props).navClass]]),
              role: "tablist",
              "aria-orientation": unref(props).vertical ? "vertical" : "horizontal"
            }, [
              renderSlot(_ctx.$slots, "tabs-start"),
              (openBlock(true), createElementBlock(Fragment, null, renderList(tabs.value, (tab, idx) => {
                var _a, _b, _c;
                return openBlock(), createElementBlock("li", {
                  key: tab.id,
                  class: normalizeClass(["nav-item", (_a = tab.titleItemClass) == null ? void 0 : _a.call(tab)]),
                  role: "presentation"
                }, [
                  createElementVNode("button", mergeProps({
                    id: tab.buttonId,
                    class: ["nav-link", [tab.navItemClasses, (_b = tab.titleLinkClass) == null ? void 0 : _b.call(tab)]],
                    role: "tab",
                    "aria-controls": tab.id,
                    "aria-selected": tab.active,
                    ref_for: true
                  }, (_c = tab.titleLinkAttrs) == null ? void 0 : _c.call(tab), {
                    onKeydown: [
                      _cache[0] || (_cache[0] = withKeys(withModifiers(($event) => keynav(-1), ["stop", "prevent"]), ["left"])),
                      _cache[1] || (_cache[1] = withKeys(withModifiers(($event) => keynav(1), ["stop", "prevent"]), ["right"])),
                      _cache[2] || (_cache[2] = withKeys(withModifiers(($event) => keynav(-999), ["stop", "prevent"]), ["page-up"])),
                      _cache[3] || (_cache[3] = withKeys(withModifiers(($event) => keynav(999), ["stop", "prevent"]), ["page-down"]))
                    ],
                    onClick: withModifiers((e) => handleClick(e, idx), ["stop", "prevent"])
                  }), [
                    tab.titleComponent ? (openBlock(), createBlock(resolveDynamicComponent(tab.titleComponent), { key: 0 })) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                      createTextVNode(toDisplayString(tab.title), 1)
                    ], 64))
                  ], 16, _hoisted_2)
                ], 2);
              }), 128)),
              renderSlot(_ctx.$slots, "tabs-end")
            ], 10, _hoisted_1)
          ], 2),
          !unref(props).end ? (openBlock(), createBlock(unref(ReusableEmptyTab).reuse, { key: 1 })) : createCommentVNode("", true)
        ]),
        _: 3
      }, 8, ["id", "class"]);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BTabs.vue_vue_type_script_setup_true_lang-BhWxG2yI.mjs.map
