const IS_BROWSER = typeof window !== "undefined" && typeof document !== "undefined" && typeof navigator !== "undefined";
const parseEventOptions = (options) => {
  const HAS_PASSIVE_EVENT_SUPPORT = (() => {
    let passiveEventSupported = false;
    if (IS_BROWSER) {
      try {
        const options2 = {
          // This function will be called when the browser
          // attempts to access the passive property
          get passive() {
            passiveEventSupported = true;
            return;
          }
        };
        WINDOW.addEventListener("test", options2, options2);
        WINDOW.removeEventListener("test", options2, options2);
      } catch {
        passiveEventSupported = false;
      }
    }
    return passiveEventSupported;
  })();
  if (HAS_PASSIVE_EVENT_SUPPORT) {
    return typeof options === "object" ? options : { capture: !!options || false };
  }
  return typeof options === "object" ? options.capture : options;
};
const eventOn = (el, eventName, handler, options) => {
  if (el && el.addEventListener) {
    el.addEventListener(eventName, handler, parseEventOptions(options));
  }
};
const eventOff = (el, eventName, handler, options) => {
  if (el && el.removeEventListener) {
    el.removeEventListener(eventName, handler, options);
  }
};
const eventOnOff = (on, eventParams) => {
  const method = on ? eventOn : eventOff;
  method(...eventParams);
};
export {
  IS_BROWSER as I,
  eventOnOff as e
};
//# sourceMappingURL=event-aFP-C_yt.mjs.map
