import { UseTimestampOptions } from '@vueuse/core';
import { MaybeRefOrGetter } from 'vue';
/**
 * A simple interval timer that counts down the remaining seconds
 *
 * @param {MaybeRefOrGetter<number>} length the total amount of time to loop through in ms
 * @param {MaybeRefOrGetter<number>} interval how often the interval should refresh. Default 1000
 * @param {Readonly<UseIntervalFnOptions>} intervalOpts opts to pass to the interval fn. Default {}
 */
export declare const useCountdown: (length: MaybeRefOrGetter<number>, interval: number | "requestAnimationFrame", timestampOpts?: UseTimestampOptions<true>) => {
    isActive: Readonly<import('vue').Ref<boolean, boolean>>;
    isPaused: Readonly<import('vue').Ref<boolean, boolean>>;
    stop: () => void;
    pause: () => void;
    resume: () => void;
    restart: () => void;
    value: import('vue').ComputedRef<number>;
};
