import { l as RX_SPACE_SPLIT, m as RX_HASH_ID, n as RX_HASH } from "../../../constants-BdrZaBP8.mjs";
const getTargets = (binding, el) => {
  const { modifiers, arg, value } = binding;
  const targets = Object.keys(modifiers || {});
  const localValue = typeof value === "string" ? value.split(RX_SPACE_SPLIT) : value;
  if (el.tagName.toLowerCase() === "a") {
    const href = el.getAttribute("href") || "";
    if (RX_HASH_ID.test(href)) {
      targets.push(href.replace(RX_HASH, ""));
    }
  }
  Array.prototype.concat.apply([], [arg, localValue]).forEach((t) => typeof t === "string" && targets.push(t));
  return targets.filter((t, index, arr) => t && arr.indexOf(t) === index);
};
const toggle = (targetIds, el) => {
  targetIds.forEach((targetId) => {
    const target = document.getElementById(targetId);
    if (target !== null) {
      target.dispatchEvent(new Event("bv-toggle"));
    }
  });
  setTimeout(() => checkVisibility(targetIds, el), 50);
};
const checkVisibility = (targetIds, el) => {
  let visible = false;
  targetIds.forEach((targetId) => {
    const target = document.getElementById(targetId);
    if (target == null ? void 0 : target.classList.contains("show")) {
      visible = true;
    }
    if (target == null ? void 0 : target.classList.contains("closing")) {
      visible = false;
    }
  });
  el.setAttribute("aria-expanded", visible ? "true" : "false");
  el.classList.remove(visible ? "collapsed" : "not-collapsed");
  el.classList.add(visible ? "not-collapsed" : "collapsed");
};
const handleUpdate = (el, binding) => {
  const targets = getTargets(binding, el);
  if (targets.length === 0) return;
  if (el.__toggle) {
    setTimeout(() => {
      el.removeEventListener("click", el.__toggle);
      el.__toggle = () => toggle(targets, el);
      el.addEventListener("click", el.__toggle);
    }, 0);
  } else {
    el.__toggle = () => toggle(targets, el);
    el.addEventListener("click", el.__toggle);
  }
  el.setAttribute("aria-controls", targets.join(" "));
  checkVisibility(targets, el);
};
const vBToggle = {
  mounted: handleUpdate,
  updated: handleUpdate,
  unmounted(el) {
    el.removeEventListener("click", el.__toggle);
    el.removeAttribute("aria-controls");
    el.removeAttribute("aria-expanded");
  }
};
export {
  vBToggle
};
//# sourceMappingURL=index.mjs.map
