import "vue";
import { r as resolveActiveStatus, a as resolveContent, b as bind, c as resolveDirectiveProps, u as unbind } from "../../../floatingUi-gCdP78vZ.mjs";
import { d as defaultsKey } from "../../../keys-CLEaYsGj.mjs";
const vBTooltip = {
  mounted(el, binding) {
    var _a, _b, _c, _d;
    const defaults = (_d = (_c = (_b = (_a = binding.instance) == null ? void 0 : _a.$.appContext) == null ? void 0 : _b.provides) == null ? void 0 : _c[defaultsKey]) == null ? void 0 : _d.value;
    const isActive = resolveActiveStatus(binding.value);
    if (!isActive) return;
    const text = resolveContent(binding.value, el);
    if (!text.content && !text.title) return;
    el.$__binding = JSON.stringify([binding.modifiers, binding.value]);
    bind(el, binding, {
      noninteractive: true,
      ...defaults["BTooltip"] || {},
      ...resolveDirectiveProps(binding, el),
      title: text.title ?? text.content ?? "",
      tooltip: isActive
    });
  },
  updated(el, binding) {
    var _a, _b, _c, _d;
    const defaults = (_d = (_c = (_b = (_a = binding.instance) == null ? void 0 : _a.$.appContext) == null ? void 0 : _b.provides) == null ? void 0 : _c[defaultsKey]) == null ? void 0 : _d.value;
    const isActive = resolveActiveStatus(binding.value);
    if (!isActive) return;
    const text = resolveContent(binding.value, el);
    if (!text.content && !text.title) return;
    delete binding.oldValue;
    if (el.$__binding === JSON.stringify([binding.modifiers, binding.value])) return;
    unbind(el);
    bind(el, binding, {
      noninteractive: true,
      ...defaults["BTooltip"] || {},
      ...resolveDirectiveProps(binding, el),
      title: text.title ?? text.content ?? "",
      tooltip: isActive
    });
    el.$__binding = JSON.stringify([binding.modifiers, binding.value]);
  },
  beforeUnmount(el) {
    unbind(el);
  }
};
export {
  vBTooltip
};
//# sourceMappingURL=index.mjs.map
