import { ref, computed, readonly } from "vue";
import { f as modalManagerPluginKey } from "../../../keys-CLEaYsGj.mjs";
const modalManagerPlugin = {
  install(app) {
    const stack = ref(/* @__PURE__ */ new Map());
    const countStack = computed(() => stack.value.size);
    const lastStack = computed(() => [...stack.value.values()].pop());
    const pushStack = (modal) => {
      stack.value.set(modal.uid, modal);
    };
    const removeStack = (modal) => {
      stack.value.delete(modal.uid);
    };
    const registry = ref(/* @__PURE__ */ new Map());
    const pushRegistry = (modal) => {
      registry.value.set(modal.uid, modal);
    };
    const removeRegistry = (modal) => {
      registry.value.delete(modal.uid);
    };
    app.provide(modalManagerPluginKey, {
      countStack,
      lastStack,
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-ignore
      registry: readonly(registry),
      stack: computed(() => [...stack.value.values()]),
      pushStack,
      removeStack,
      pushRegistry,
      removeRegistry
    });
  }
};
export {
  modalManagerPlugin
};
//# sourceMappingURL=index.mjs.map
