import { ref, toRef, markRaw, watch } from "vue";
import { t as toastPluginKey } from "../../../keys-CLEaYsGj.mjs";
const posDefault = "top-end";
const toastPlugin = {
  install(app) {
    const toasts = ref([]);
    const _isAppend = ref(false);
    const _setIsAppend = (value) => {
      _isAppend.value = value;
    };
    const show = (obj = {}) => {
      var _a, _b, _c;
      const resolvedProps = toRef(obj.props);
      const _self = Symbol();
      const toastToAdd = {
        component: !obj.component ? void 0 : markRaw(obj.component),
        props: {
          ...resolvedProps.value,
          pos: ((_a = resolvedProps.value) == null ? void 0 : _a.pos) || posDefault,
          _modelValue: ((_b = resolvedProps.value) == null ? void 0 : _b.value) || 5e3,
          _self
        }
      };
      if (((_c = resolvedProps.value) == null ? void 0 : _c.appendToast) !== void 0 ? resolvedProps.value.appendToast : _isAppend.value) {
        toasts.value.push(toastToAdd);
      } else {
        toasts.value.unshift(toastToAdd);
      }
      watch(resolvedProps, (newValue) => {
        const previousIndex = toasts.value.findIndex((el) => el.props._self === _self);
        if (previousIndex === -1) return;
        toasts.value.splice(previousIndex, 1, {
          component: !obj.component ? void 0 : markRaw(obj.component),
          props: {
            ...toasts.value[previousIndex].props,
            ...newValue,
            _modelValue: (newValue == null ? void 0 : newValue.value) || toasts.value[previousIndex].props._modelValue || 5e3
          }
        });
      });
      return _self;
    };
    const remove = (self) => {
      toasts.value = toasts.value.filter((el) => el.props._self !== self);
    };
    const leave = (self) => {
      const toastIndex = toasts.value.findIndex((el) => el.props._self === self);
      if (toastIndex === -1) return;
      toasts.value.splice(toastIndex, 1, {
        component: !toasts.value[toastIndex].component ? void 0 : markRaw(toasts.value[toastIndex].component),
        props: {
          ...toasts.value[toastIndex].props,
          _modelValue: false
        }
      });
    };
    app.provide(toastPluginKey, {
      _setIsAppend,
      toasts,
      show,
      remove,
      leave
    });
  }
};
export {
  toastPlugin
};
//# sourceMappingURL=index.mjs.map
