/**
 * Items that are omitted from the BvEventInit constructor arg
 */
export type BvEventConstructorOmittables = 'eventType' | 'defaultPrevented';
export declare class BvEvent {
    readonly cancelable: boolean;
    readonly componentId: string | null;
    private _defaultPrevented;
    readonly eventType: string;
    readonly nativeEvent: string | null;
    private _preventDefault;
    readonly relatedTarget: EventTarget | null;
    readonly target: EventTarget | null;
    get defaultPrevented(): boolean;
    protected set defaultPrevented(prop: boolean);
    get preventDefault(): () => void;
    protected set preventDefault(setter: () => void);
    constructor(eventType: string, eventInit?: Partial<Omit<BvEvent, BvEventConstructorOmittables>>);
    static get Defaults(): {
        cancelable: boolean;
        componentId: null;
        eventType: string;
        nativeEvent: null;
        relatedTarget: null;
        target: null;
    };
}
export declare class BvTriggerableEvent extends BvEvent {
    readonly trigger: string | null;
    constructor(eventType: string, eventInit?: Partial<Omit<BvTriggerableEvent, BvEventConstructorOmittables>>);
    static get Defaults(): {
        trigger: null;
        cancelable: boolean;
        componentId: null;
        eventType: string;
        nativeEvent: null;
        relatedTarget: null;
        target: null;
    };
}
export declare class BvCarouselEvent extends BvEvent {
    readonly from: number;
    readonly to: number;
    readonly direction: 'left' | 'right';
    constructor(eventType: string, eventInit: Partial<Omit<BvEvent, BvEventConstructorOmittables>> & {
        from: number;
        to: number;
        direction: 'left' | 'right';
    });
    static get Defaults(): {
        cancelable: boolean;
        componentId: null;
        eventType: string;
        nativeEvent: null;
        relatedTarget: null;
        target: null;
    };
}
