import { computed, toValue } from "vue";
const useColorVariantClasses = (obj) => computed(() => {
  let props = toValue(obj);
  props = {
    ...props,
    variant: props.variant ?? null,
    bgVariant: props.bgVariant ?? null,
    textVariant: props.textVariant ?? null
  };
  return {
    [`text-bg-${props.variant}`]: props.variant !== null,
    [`text-${props.textVariant}`]: props.textVariant !== null,
    [`bg-${props.bgVariant}`]: props.bgVariant !== null
  };
});
export {
  useColorVariantClasses as u
};
//# sourceMappingURL=useColorVariantClasses-BDBjYQXI.mjs.map
