import { ref, onMounted, onActivated, nextTick } from "vue";
import { u as useAriaInvalid } from "./useAriaInvalid-BTUbGj3Y.mjs";
import { u as useId } from "./useId-BrAgQfKM.mjs";
import { e as useFocus } from "./index-DngH9Pjm.mjs";
import { u as useToNumber, l as useDebounceFn } from "./index-DlGgXMQF.mjs";
const normalizeInput = (v, modelModifiers) => {
  if (v === null) return;
  let update = v;
  if (modelModifiers.trim) update = update.toString().trim();
  if (modelModifiers.number && typeof update === "string" && update !== "") {
    const parsed = Number.parseFloat(update);
    update = Number.isNaN(parsed) ? update : parsed;
  }
  return update;
};
const useFormInput = (props, modelValue, modelModifiers) => {
  const input = ref(null);
  const computedId = useId(() => props.id, "input");
  const debounceNumber = useToNumber(() => props.debounce ?? 0);
  const debounceMaxWaitNumber = useToNumber(() => props.debounceMaxWait ?? NaN);
  const internalUpdateModelValue = useDebounceFn(
    (value) => {
      modelValue.value = value;
    },
    () => modelModifiers.lazy === true ? 0 : debounceNumber.value,
    { maxWait: () => modelModifiers.lazy === true ? NaN : debounceMaxWaitNumber.value }
  );
  const updateModelValue = (value, force = false) => {
    if (modelModifiers.lazy === true && force === false) return;
    internalUpdateModelValue(value);
  };
  const { focused } = useFocus(input, {
    initialValue: props.autofocus
  });
  const _formatValue = (value, evt, force = false) => {
    if (props.formatter !== void 0 && (!props.lazyFormatter || force)) {
      return props.formatter(value, evt);
    }
    return value;
  };
  onMounted(() => {
    var _a;
    if (input.value) {
      input.value.value = ((_a = modelValue.value) == null ? void 0 : _a.toString()) ?? "";
    }
  });
  onActivated(() => {
    nextTick(() => {
      if (props.autofocus) {
        focused.value = true;
      }
    });
  });
  const computedAriaInvalid = useAriaInvalid(
    () => props.ariaInvalid,
    () => props.state
  );
  const onInput = (evt) => {
    const { value } = evt.target;
    const formattedValue = _formatValue(value, evt);
    if (evt.defaultPrevented) {
      evt.preventDefault();
      return;
    }
    const nextModel = formattedValue;
    updateModelValue(nextModel);
  };
  const onChange = (evt) => {
    const { value } = evt.target;
    const formattedValue = _formatValue(value, evt);
    if (evt.defaultPrevented) {
      evt.preventDefault();
      return;
    }
    const nextModel = formattedValue;
    if (modelValue.value !== nextModel) {
      updateModelValue(formattedValue, true);
    }
  };
  const onBlur = (evt) => {
    if (!modelModifiers.lazy && !props.lazyFormatter) return;
    const { value } = evt.target;
    const formattedValue = _formatValue(value, evt, true);
    const nextModel = formattedValue;
    if (modelValue.value !== nextModel) {
      updateModelValue(formattedValue, true);
    }
  };
  const focus = () => {
    if (!props.disabled) {
      focused.value = true;
    }
  };
  const blur = () => {
    if (!props.disabled) {
      focused.value = false;
    }
  };
  return {
    input,
    computedId,
    computedAriaInvalid,
    onInput,
    onChange,
    onBlur,
    focus,
    blur
  };
};
export {
  normalizeInput as n,
  useFormInput as u
};
//# sourceMappingURL=useFormInput-B-34kU2d.mjs.map
