import { h as getSSRHandler, i as unrefElement } from "./index-DngH9Pjm.mjs";
import { getCurrentInstance, watch, computed, inject } from "vue";
import { f as modalManagerPluginKey } from "./keys-CLEaYsGj.mjs";
import { a as tryOnScopeDispose } from "./index-DlGgXMQF.mjs";
const modalOpenClassName = "modal-open";
const useSharedModalStack = () => {
  const modalManagerPlugin = inject(modalManagerPluginKey);
  const dispose = (modal) => {
    modalManagerPlugin == null ? void 0 : modalManagerPlugin.removeStack(modal);
    modalManagerPlugin == null ? void 0 : modalManagerPlugin.removeRegistry(modal);
  };
  const updateHTMLAttrs = getSSRHandler("updateHTMLAttrs", (selector, attribute, value) => {
    const el = typeof selector === "string" ? window == null ? void 0 : window.document.querySelector(selector) : unrefElement(selector);
    if (!el) return;
    if (attribute === "class") {
      el.classList.toggle(modalOpenClassName, value === modalOpenClassName);
    } else {
      el.setAttribute(attribute, value);
    }
  });
  tryOnScopeDispose(() => {
    updateHTMLAttrs("body", "class", "");
  });
  watch(
    () => modalManagerPlugin == null ? void 0 : modalManagerPlugin.countStack.value,
    (newValue) => {
      if (newValue === void 0) return;
      updateHTMLAttrs("body", "class", newValue > 0 ? modalOpenClassName : "");
    }
  );
  return {
    ...modalManagerPlugin,
    dispose
  };
};
const useModalManager = (modalOpen, initialValue) => {
  const { pushRegistry, pushStack, removeStack, stack, dispose, countStack } = useSharedModalStack();
  const currentModal = getCurrentInstance();
  if (!currentModal || currentModal.type.__name !== "BModal") {
    throw new Error("useModalManager must only use in BModal component");
  }
  pushRegistry == null ? void 0 : pushRegistry(currentModal);
  tryOnScopeDispose(() => {
    dispose(currentModal);
  });
  const setInStack = (newValue, oldValue) => {
    if (newValue) {
      pushStack == null ? void 0 : pushStack(currentModal);
    } else if (oldValue && !newValue) {
      removeStack == null ? void 0 : removeStack(currentModal);
    }
  };
  setInStack(initialValue, initialValue);
  watch(modalOpen, setInStack);
  return {
    activePosition: computed(
      () => stack == null ? void 0 : stack.value.findIndex((el) => {
        var _a, _b;
        return ((_a = el.exposed) == null ? void 0 : _a.id) === ((_b = currentModal.exposed) == null ? void 0 : _b.id);
      })
    ),
    activeModalCount: countStack,
    stackWithoutSelf: computed(
      () => (stack == null ? void 0 : stack.value.filter((el) => {
        var _a, _b;
        return ((_a = el.exposed) == null ? void 0 : _a.id) !== ((_b = currentModal.exposed) == null ? void 0 : _b.id);
      })) ?? []
    )
  };
};
export {
  useModalManager as a,
  useSharedModalStack as u
};
//# sourceMappingURL=useModalManager-N1MQhnkH.mjs.map
