import { defineComponent, mergeModels, ref, useModel, computed, openBlock, createBlock, resolveDynamicComponent, mergeProps, unref, withCtx, renderSlot, createElementBlock, Fragment, createTextVNode, toDisplayString, createCommentVNode, createVNode } from "vue";
import { _ as _sfc_main$2 } from "./BSpinner.vue_vue_type_script_setup_true_lang-CXYbvCe5.mjs";
import { u as useBLinkHelper } from "./useBLinkHelper-Bvtov_sk.mjs";
import { u as useLinkClasses, _ as _sfc_main$1 } from "./BLink.vue_vue_type_script_setup_true_lang-DS4JR4ch.mjs";
import { o as onKeyStroke } from "./index-DngH9Pjm.mjs";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BButton",
  props: /* @__PURE__ */ mergeModels({
    loading: { type: Boolean, default: false },
    loadingFill: { type: Boolean, default: false },
    loadingText: { default: "Loading..." },
    pill: { type: Boolean, default: false },
    size: { default: "md" },
    squared: { type: Boolean, default: false },
    tag: { default: "button" },
    type: { default: "button" },
    variant: { default: "secondary" },
    active: { type: Boolean, default: false },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: void 0 },
    href: { default: void 0 },
    icon: { type: Boolean, default: false },
    noRel: { type: Boolean },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    routerTag: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: null }
  }, {
    "pressed": { type: Boolean, ...{ default: void 0 } },
    "pressedModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["click"], ["update:pressed"]),
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BButton");
    const emit = __emit;
    const element = ref(null);
    const pressedValue = useModel(__props, "pressed");
    const { computedLink, computedLinkProps } = useBLinkHelper(props, [
      "active-class",
      "exact-active-class",
      "replace",
      "routerComponentName",
      "routerTag"
    ]);
    const isToggle = computed(() => typeof pressedValue.value === "boolean");
    const isButton = computed(
      () => props.tag === "button" && props.href === void 0 && props.to === void 0
    );
    const isBLink = computed(() => props.to !== void 0);
    const nonStandardTag = computed(() => props.href !== void 0 ? false : !isButton.value);
    const linkProps = computed(() => isBLink.value ? computedLinkProps.value : []);
    const computedAriaDisabled = computed(() => {
      if (props.href === "#" && props.disabled) return true;
      return nonStandardTag.value ? props.disabled : null;
    });
    const variantIsLinkType = computed(() => {
      var _a;
      return ((_a = props.variant) == null ? void 0 : _a.startsWith("link")) || false;
    });
    const variantIsLinkTypeSubset = computed(() => {
      var _a;
      return ((_a = props.variant) == null ? void 0 : _a.startsWith("link-")) || false;
    });
    const linkValueClasses = useLinkClasses(
      computed(() => {
        var _a;
        return {
          ...variantIsLinkType.value && {
            icon: props.icon,
            opacity: props.opacity,
            opacityHover: props.opacityHover,
            underlineOffset: props.underlineOffset,
            underlineOffsetHover: props.underlineOffsetHover,
            underlineOpacity: props.underlineOpacity,
            underlineOpacityHover: props.underlineOpacityHover,
            underlineVariant: props.underlineVariant,
            variant: variantIsLinkTypeSubset.value === true ? (_a = props.variant) == null ? void 0 : _a.slice(5) : null
          }
        };
      })
    );
    const computedClasses = computed(() => [
      variantIsLinkType.value === true && computedLink.value === false ? linkValueClasses.value : void 0,
      [`btn-${props.size}`],
      {
        [`btn-${props.variant}`]: props.variant !== null && variantIsLinkTypeSubset.value === false,
        "active": props.active || pressedValue.value,
        "rounded-pill": props.pill,
        "rounded-0": props.squared,
        "disabled": props.disabled
      }
    ]);
    const computedTag = computed(() => isBLink.value ? _sfc_main$1 : props.href ? "a" : props.tag);
    const clicked = (e) => {
      if (props.disabled) {
        e.preventDefault();
        e.stopPropagation();
        return;
      }
      emit("click", e);
      if (isToggle.value) pressedValue.value = !pressedValue.value;
    };
    onKeyStroke(
      [" ", "enter"],
      (e) => {
        var _a;
        if (props.href === "#") {
          e.preventDefault();
          (_a = element.value) == null ? void 0 : _a.click();
        }
      },
      { target: element }
    );
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(computedTag.value), mergeProps({
        ref_key: "element",
        ref: element,
        class: "btn"
      }, linkProps.value, {
        class: computedClasses.value,
        "aria-disabled": computedAriaDisabled.value,
        "aria-pressed": isToggle.value ? pressedValue.value : null,
        autocomplete: isToggle.value ? "off" : null,
        disabled: isButton.value ? unref(props).disabled : null,
        href: unref(props).href,
        rel: unref(computedLink) ? unref(props).rel : null,
        role: nonStandardTag.value || unref(computedLink) ? "button" : null,
        target: unref(computedLink) ? unref(props).target : null,
        type: isButton.value ? unref(props).type : null,
        to: !isButton.value ? unref(props).to : null,
        onClick: clicked
      }), {
        default: withCtx(() => [
          unref(props).loading ? renderSlot(_ctx.$slots, "loading", { key: 0 }, () => [
            !unref(props).loadingFill ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
              createTextVNode(toDisplayString(unref(props).loadingText), 1)
            ], 64)) : createCommentVNode("", true),
            renderSlot(_ctx.$slots, "loading-spinner", {}, () => [
              createVNode(_sfc_main$2, {
                small: unref(props).size !== "lg",
                label: unref(props).loadingFill ? unref(props).loadingText : void 0
              }, null, 8, ["small", "label"])
            ])
          ]) : renderSlot(_ctx.$slots, "default", { key: 1 })
        ]),
        _: 3
      }, 16, ["class", "aria-disabled", "aria-pressed", "autocomplete", "disabled", "href", "rel", "role", "target", "type", "to"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BButton.vue_vue_type_script_setup_true_lang-DUrERyIC.mjs.map
