import { defineComponent, mergeModels, useSlots, useModel, ref, onMounted, computed, watch, provide, toRef, openBlock, createElementBlock, unref, normalizeClass, Fragment, renderList, createCommentVNode, createElementVNode, createVNode, TransitionGroup, withCtx, withDirectives, createBlock, resolveDynamicComponent, normalizeStyle, vShow, toDisplayString, inject, renderSlot } from "vue";
import { b as BvCarouselEvent } from "./classes-IC0yVJlq.mjs";
import { u as useId } from "./useId-SLUTyEVA.mjs";
import { l as useElementHover, m as useSwipe, o as onKeyStroke } from "./index-DngH9Pjm.mjs";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { u as carouselInjectionKey } from "./keys-DuZp76_V.mjs";
import { u as useToNumber, j as useIntervalFn } from "./index-DlGgXMQF.mjs";
import { _ as _sfc_main$2 } from "./BImg.vue_vue_type_script_setup_true_lang-B4G4OXC_.mjs";
import { i as isEmptySlot } from "./dom-B-SQyhbA.mjs";
const getSlotElements = (slot, filterBy) => ((slot == null ? void 0 : slot()) ?? []).reduce((arr, slot2) => {
  if (typeof slot2.type === "symbol") {
    arr = arr.concat(slot2.children);
  } else {
    arr.push(slot2);
  }
  return arr;
}, []).filter((child) => {
  var _a;
  return ((_a = child.type) == null ? void 0 : _a.__name) === filterBy;
});
const _hoisted_1$1 = ["id"];
const _hoisted_2$1 = {
  key: 0,
  class: "carousel-indicators"
};
const _hoisted_3$1 = ["aria-current", "aria-label", "onClick"];
const _hoisted_4$1 = { class: "visually-hidden" };
const _hoisted_5 = { class: "visually-hidden" };
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BCarousel",
  props: /* @__PURE__ */ mergeModels({
    background: { default: void 0 },
    controls: { type: Boolean, default: false },
    controlsNextText: { default: "Next" },
    controlsPrevText: { default: "Previous" },
    fade: { type: Boolean, default: false },
    id: { default: void 0 },
    imgHeight: { default: void 0 },
    imgWidth: { default: void 0 },
    indicators: { type: Boolean, default: false },
    indicatorsButtonLabel: { default: "Slide" },
    interval: { default: 5e3 },
    keyboard: { type: Boolean, default: true },
    noAnimation: { type: Boolean, default: false },
    noHoverPause: { type: Boolean, default: false },
    noTouch: { type: Boolean, default: false },
    noWrap: { type: Boolean, default: false },
    ride: { type: [Boolean, String], default: false },
    rideReverse: { type: Boolean, default: false },
    touchThreshold: { default: 50 }
  }, {
    "modelValue": { default: 0 },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["slide", "slid", "click:prev", "click:next"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BCarousel");
    const emit = __emit;
    const slots = useSlots();
    const computedId = useId(() => props.id, "carousel");
    const modelValue = useModel(__props, "modelValue");
    const slideValues = ref(null);
    const touchThresholdNumber = useToNumber(() => props.touchThreshold);
    const slideInterval = ref(null);
    onMounted(() => {
      var _a, _b;
      slideInterval.value = ((_b = (_a = slideValues.value) == null ? void 0 : _a.find((slid) => slid.$el.style.display !== "none")) == null ? void 0 : _b._interval) ?? null;
    });
    const intervalNumber = useToNumber(() => slideInterval.value ?? props.interval);
    const isTransitioning = ref(false);
    const rideStarted = ref(false);
    const direction = ref(true);
    const relatedTarget = ref(null);
    const element = ref(null);
    const previousModelValue = ref(modelValue.value);
    const isHovering = useElementHover(element);
    const enterClasses = computed(
      () => `carousel-item carousel-item-${!direction.value ? "next" : "prev"} carousel-item-${!direction.value ? "start" : "end"}`
    );
    const leaveClasses = computed(
      () => `carousel-item active carousel-item-${direction.value ? "start" : "end"}`
    );
    const { pause, resume } = useIntervalFn(
      () => {
        props.rideReverse ? prev() : next();
      },
      intervalNumber,
      { immediate: props.ride === "carousel" }
    );
    const isRiding = computed(
      () => props.ride === true && rideStarted.value === true || props.ride === "carousel"
    );
    const slides = computed(() => getSlotElements(slots.default, "BCarouselSlide"));
    const computedClasses = computed(() => ({ "carousel-fade": props.fade }));
    const buildBvCarouselEvent = (event) => {
      var _a;
      return new BvCarouselEvent(event, {
        componentId: computedId.value,
        cancelable: false,
        target: element.value,
        direction: direction.value ? "right" : "left",
        from: previousModelValue.value,
        to: modelValue.value,
        relatedTarget: ((_a = relatedTarget.value) == null ? void 0 : _a.children[modelValue.value]) ?? null
      });
    };
    const goToValue = (value) => {
      if (isTransitioning.value === true) return;
      if (props.ride === true) {
        rideStarted.value = true;
      }
      if (isRiding.value === true) {
        resume();
      }
      direction.value = value < modelValue.value ? false : true;
      if (value >= slides.value.length) {
        if (props.noWrap) return;
        modelValue.value = 0;
        return;
      }
      if (value < 0) {
        if (props.noWrap) return;
        modelValue.value = slides.value.length - 1;
        return;
      }
      previousModelValue.value = modelValue.value;
      modelValue.value = value;
    };
    const prev = () => {
      goToValue(modelValue.value - 1);
    };
    const next = () => {
      goToValue(modelValue.value + 1);
    };
    const onKeydown = (fn) => {
      if (props.keyboard === false) return;
      fn();
    };
    const onMouseEnter = () => {
      if (props.noHoverPause) return;
      pause();
    };
    const onMouseLeave = () => {
      if (!isRiding.value) return;
      resume();
    };
    const { lengthX } = useSwipe(element, {
      passive: true,
      onSwipeStart() {
        if (props.noTouch === true) return;
        pause();
      },
      onSwipeEnd() {
        if (props.noTouch === true) return;
        const resumeRiding = () => {
          if (isRiding.value === false) return;
          resume();
        };
        if (lengthX.value >= touchThresholdNumber.value) {
          next();
          resumeRiding();
          return;
        }
        if (lengthX.value <= -touchThresholdNumber.value) {
          prev();
          resumeRiding();
        }
      }
    });
    const onBeforeLeave = () => {
      emit("slide", buildBvCarouselEvent("slide"));
      isTransitioning.value = true;
    };
    const onAfterLeave = () => {
      emit("slid", buildBvCarouselEvent("slid"));
      isTransitioning.value = false;
    };
    const onAfterEnter = (el) => {
      if (modelValue.value !== 0) {
        el.classList.add("carousel-item");
      }
    };
    const onEnter = (el) => {
      var _a, _b;
      slideInterval.value = ((_b = (_a = slideValues.value) == null ? void 0 : _a.find((slid) => slid.$el === el)) == null ? void 0 : _b._interval) ?? null;
    };
    onKeyStroke(
      "ArrowLeft",
      () => {
        onKeydown(prev);
      },
      { target: element }
    );
    onKeyStroke(
      "ArrowRight",
      () => {
        onKeydown(next);
      },
      { target: element }
    );
    watch(
      () => props.ride,
      () => {
        rideStarted.value = false;
      }
    );
    watch(isHovering, (newValue) => {
      if (newValue) {
        onMouseEnter();
        return;
      }
      onMouseLeave();
    });
    const onClickPrev = (event) => {
      emit("click:prev", event);
      if (event.defaultPrevented) return;
      prev();
    };
    const onClickNext = (event) => {
      emit("click:next", event);
      if (event.defaultPrevented) return;
      next();
    };
    __expose({
      next,
      pause,
      prev,
      resume
    });
    provide(carouselInjectionKey, {
      background: toRef(() => props.background),
      width: toRef(() => props.imgWidth),
      height: toRef(() => props.imgHeight)
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        id: unref(computedId),
        ref_key: "element",
        ref: element,
        class: normalizeClass(["carousel slide pointer-event", computedClasses.value])
      }, [
        unref(props).indicators ? (openBlock(), createElementBlock("div", _hoisted_2$1, [
          (openBlock(true), createElementBlock(Fragment, null, renderList(slides.value.length, (_, i) => {
            return openBlock(), createElementBlock("button", {
              key: i,
              type: "button",
              "data-bs-target": "",
              class: normalizeClass(i === modelValue.value ? "active" : ""),
              "aria-current": i === modelValue.value ? true : void 0,
              "aria-label": `${unref(props).indicatorsButtonLabel} ${i}`,
              onClick: ($event) => goToValue(i)
            }, null, 10, _hoisted_3$1);
          }), 128))
        ])) : createCommentVNode("", true),
        createElementVNode("div", {
          ref_key: "relatedTarget",
          ref: relatedTarget,
          class: "carousel-inner"
        }, [
          createVNode(TransitionGroup, {
            "enter-from-class": enterClasses.value,
            "enter-active-class": enterClasses.value,
            "enter-to-class": enterClasses.value,
            "leave-from-class": leaveClasses.value,
            "leave-active-class": leaveClasses.value,
            "leave-to-class": leaveClasses.value,
            onBeforeLeave,
            onAfterLeave,
            onAfterEnter,
            onEnter
          }, {
            default: withCtx(() => [
              (openBlock(true), createElementBlock(Fragment, null, renderList(slides.value, (slide, i) => {
                return withDirectives((openBlock(), createBlock(resolveDynamicComponent(slide), {
                  key: i,
                  ref_for: true,
                  ref_key: "slideValues",
                  ref: slideValues,
                  class: normalizeClass({ active: i === modelValue.value && isTransitioning.value === false }),
                  style: normalizeStyle(unref(props).noAnimation && { transition: "none" })
                }, null, 8, ["class", "style"])), [
                  [vShow, i === modelValue.value]
                ]);
              }), 128))
            ]),
            _: 1
          }, 8, ["enter-from-class", "enter-active-class", "enter-to-class", "leave-from-class", "leave-active-class", "leave-to-class"])
        ], 512),
        unref(props).controls ? (openBlock(), createElementBlock(Fragment, { key: 1 }, [
          createElementVNode("button", {
            class: "carousel-control-prev",
            type: "button",
            onClick: onClickPrev
          }, [
            _cache[0] || (_cache[0] = createElementVNode("span", {
              class: "carousel-control-prev-icon",
              "aria-hidden": "true"
            }, null, -1)),
            createElementVNode("span", _hoisted_4$1, toDisplayString(unref(props).controlsPrevText), 1)
          ]),
          createElementVNode("button", {
            class: "carousel-control-next",
            type: "button",
            onClick: onClickNext
          }, [
            _cache[1] || (_cache[1] = createElementVNode("span", {
              class: "carousel-control-next-icon",
              "aria-hidden": "true"
            }, null, -1)),
            createElementVNode("span", _hoisted_5, toDisplayString(unref(props).controlsNextText), 1)
          ])
        ], 64)) : createCommentVNode("", true)
      ], 10, _hoisted_1$1);
    };
  }
});
const _hoisted_1 = ["innerHTML"];
const _hoisted_2 = { key: 1 };
const _hoisted_3 = ["innerHTML"];
const _hoisted_4 = { key: 1 };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BCarouselSlide",
  props: {
    background: { default: void 0 },
    caption: { default: void 0 },
    captionHtml: { default: void 0 },
    captionTag: { default: "h3" },
    contentTag: { default: "div" },
    contentVisibleUp: { default: void 0 },
    id: { default: void 0 },
    imgAlt: { default: void 0 },
    imgBlank: { type: Boolean, default: false },
    imgBlankColor: { default: "transparent" },
    imgHeight: { default: void 0 },
    imgSrc: { default: void 0 },
    imgSrcset: { default: void 0 },
    imgWidth: { default: void 0 },
    interval: { default: void 0 },
    text: { default: void 0 },
    textHtml: { default: void 0 },
    textTag: { default: "p" }
  },
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BCarouselSlide");
    const slots = useSlots();
    const parentData = inject(carouselInjectionKey, null);
    const hasText = computed(() => props.text || props.textHtml || !isEmptySlot(slots.text));
    const hasCaption = computed(() => props.caption || props.captionHtml || !isEmptySlot(slots.caption));
    const hasContent = computed(() => hasText.value || hasCaption.value || !isEmptySlot(slots.default));
    const computedStyle = computed(() => ({
      background: `${props.background || (parentData == null ? void 0 : parentData.background.value) || "rgb(171, 171, 171)"} none repeat scroll 0% 0%`
    }));
    const computedContentClasses = computed(() => ({
      "d-none": props.contentVisibleUp !== void 0,
      [`d-${props.contentVisibleUp}-block`]: props.contentVisibleUp !== void 0
    }));
    __expose({
      _interval: toRef(() => props.interval)
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: "carousel-item",
        style: normalizeStyle(computedStyle.value)
      }, [
        renderSlot(_ctx.$slots, "img", {}, () => {
          var _a, _b;
          return [
            createVNode(_sfc_main$2, {
              class: "d-block w-100",
              alt: unref(props).imgAlt,
              srcset: unref(props).imgSrcset,
              src: unref(props).imgSrc,
              width: unref(props).imgWidth || ((_a = unref(parentData)) == null ? void 0 : _a.width.value),
              height: unref(props).imgHeight || ((_b = unref(parentData)) == null ? void 0 : _b.height.value),
              blank: unref(props).imgBlank,
              "blank-color": unref(props).imgBlankColor
            }, null, 8, ["alt", "srcset", "src", "width", "height", "blank", "blank-color"])
          ];
        }),
        hasContent.value ? (openBlock(), createBlock(resolveDynamicComponent(unref(props).contentTag), {
          key: 0,
          class: normalizeClass(["carousel-caption", computedContentClasses.value])
        }, {
          default: withCtx(() => [
            hasCaption.value ? (openBlock(), createBlock(resolveDynamicComponent(unref(props).captionTag), { key: 0 }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "caption", {}, () => [
                  unref(props).captionHtml ? (openBlock(), createElementBlock("span", {
                    key: 0,
                    innerHTML: unref(props).captionHtml
                  }, null, 8, _hoisted_1)) : (openBlock(), createElementBlock("span", _hoisted_2, toDisplayString(unref(props).caption), 1))
                ])
              ]),
              _: 3
            })) : createCommentVNode("", true),
            hasText.value ? (openBlock(), createBlock(resolveDynamicComponent(unref(props).textTag), { key: 1 }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "text", {}, () => [
                  unref(props).textHtml ? (openBlock(), createElementBlock("span", {
                    key: 0,
                    innerHTML: unref(props).textHtml
                  }, null, 8, _hoisted_3)) : (openBlock(), createElementBlock("span", _hoisted_4, toDisplayString(unref(props).text), 1))
                ])
              ]),
              _: 3
            })) : createCommentVNode("", true),
            renderSlot(_ctx.$slots, "default")
          ]),
          _: 3
        }, 8, ["class"])) : createCommentVNode("", true)
      ], 4);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BCarouselSlide.vue_vue_type_script_setup_true_lang-CGqYLLHu.mjs.map
