import { defineComponent, mergeModels, useModel, ref, computed, watch, onMounted, nextTick, readonly, provide, toRef, openBlock, createElementBlock, Fragment, renderSlot, normalizeProps, guardReactiveProps, createBlock, resolveDynamicComponent, unref, mergeProps, withCtx } from "vue";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { u as useId } from "./useId-SLUTyEVA.mjs";
import { c as useEventListener } from "./index-DngH9Pjm.mjs";
import { c as collapseInjectionKey } from "./keys-DuZp76_V.mjs";
import { a as BvTriggerableEvent } from "./classes-IC0yVJlq.mjs";
import { g as getTransitionDelay } from "./dom-B-SQyhbA.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BCollapse",
  props: /* @__PURE__ */ mergeModels({
    horizontal: { type: Boolean, default: false },
    id: { default: void 0 },
    isNav: { type: Boolean, default: false },
    skipAnimation: { type: Boolean, default: false },
    tag: { default: "div" },
    toggle: { type: Boolean, default: false },
    visible: { type: Boolean, default: false }
  }, {
    "modelValue": { type: Boolean, ...{
      default: false
    } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["hidden", "hide", "hide-prevented", "show", "show-prevented", "shown"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BCollapse");
    const emit = __emit;
    const buildTriggerableEvent = (type, opts = {}) => new BvTriggerableEvent(type, {
      cancelable: false,
      target: element.value || null,
      relatedTarget: null,
      trigger: null,
      ...opts,
      componentId: computedId.value
    });
    const modelValue = useModel(__props, "modelValue");
    const computedId = useId(() => props.id, "collapse");
    const element = ref(null);
    const isCollapsing = ref(false);
    const showRef = ref(modelValue.value);
    const computedClasses = computed(() => ({
      "show": showRef.value,
      "navbar-collapse": props.isNav,
      "collapsing": isCollapsing.value,
      "closing": showRef.value && !modelValue.value,
      "collapse-horizontal": props.horizontal
    }));
    const hide = () => {
      modelValue.value = false;
    };
    const show = () => {
      modelValue.value = true;
    };
    const toggleFn = () => {
      modelValue.value = !modelValue.value;
    };
    const sharedSlots = computed(() => ({
      toggle: toggleFn,
      show,
      hide,
      id: computedId.value,
      visible: modelValue.value
    }));
    let revealTimeout;
    let hideTimeout;
    let _skipAnimation = props.skipAnimation;
    const reveal = () => {
      const event = buildTriggerableEvent("show", { cancelable: true });
      emit("show", event);
      if (event.defaultPrevented) {
        emit("show-prevented");
        return;
      }
      clearTimeout(hideTimeout);
      clearTimeout(revealTimeout);
      showRef.value = true;
      if (_skipAnimation) return;
      isCollapsing.value = true;
      nextTick(() => {
        if (element.value === null) return;
        if (props.horizontal) {
          element.value.style.width = `${element.value.scrollWidth}px`;
        } else {
          element.value.style.height = `${element.value.scrollHeight}px`;
        }
        revealTimeout = setTimeout(() => {
          isCollapsing.value = false;
          emit("shown");
          if (element.value === null) return;
          element.value.style.height = "";
          element.value.style.width = "";
        }, getTransitionDelay(element.value));
      });
    };
    const hideFn = () => {
      const event = buildTriggerableEvent("hide", { cancelable: true });
      emit("hide", event);
      if (event.defaultPrevented) {
        emit("hide-prevented");
        return;
      }
      clearTimeout(revealTimeout);
      clearTimeout(hideTimeout);
      if (element.value === null) return;
      if (_skipAnimation) {
        showRef.value = false;
        return;
      }
      if (isCollapsing.value) {
        element.value.style.height = ``;
        element.value.style.width = ``;
      } else {
        if (props.horizontal) {
          element.value.style.width = `${element.value.scrollWidth}px`;
        } else {
          element.value.style.height = `${element.value.scrollHeight}px`;
        }
      }
      element.value.offsetHeight;
      isCollapsing.value = true;
      nextTick(() => {
        if (element.value === null) return;
        element.value.style.height = ``;
        element.value.style.width = ``;
        hideTimeout = setTimeout(() => {
          showRef.value = false;
          isCollapsing.value = false;
          emit("hidden");
        }, getTransitionDelay(element.value));
      });
    };
    watch(modelValue, () => {
      modelValue.value ? reveal() : hideFn();
    });
    onMounted(() => {
      if (element.value === null) return;
      if (!modelValue.value && props.toggle) {
        nextTick(() => {
          modelValue.value = true;
        });
      }
    });
    watch(
      () => props.skipAnimation,
      (newval) => {
        _skipAnimation = newval;
      }
    );
    if (props.visible) {
      _skipAnimation = true;
      modelValue.value = true;
      nextTick(() => {
        _skipAnimation = props.skipAnimation;
      });
    }
    watch(
      () => props.visible,
      (newval) => {
        _skipAnimation = true;
        newval ? show() : hide();
        nextTick(() => {
          _skipAnimation = props.skipAnimation;
        });
      }
    );
    useEventListener(element, "bv-toggle", () => {
      modelValue.value = !modelValue.value;
    });
    __expose({
      hide,
      isNav: props.isNav,
      show,
      toggle: toggleFn,
      visible: readonly(showRef)
    });
    provide(collapseInjectionKey, {
      id: computedId,
      hide,
      show,
      toggle: toggleFn,
      visible: readonly(showRef),
      isNav: toRef(() => props.isNav)
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        renderSlot(_ctx.$slots, "header", normalizeProps(guardReactiveProps(sharedSlots.value))),
        (openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), mergeProps({
          id: unref(computedId),
          ref_key: "element",
          ref: element,
          class: ["collapse", computedClasses.value],
          "is-nav": unref(props).isNav
        }, _ctx.$attrs), {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(sharedSlots.value)))
          ]),
          _: 3
        }, 16, ["id", "class", "is-nav"])),
        renderSlot(_ctx.$slots, "footer", normalizeProps(guardReactiveProps(sharedSlots.value)))
      ], 64);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BCollapse.vue_vue_type_script_setup_true_lang-DMQdKnW0.mjs.map
