import { defineComponent, mergeModels, useModel, inject, computed, ref, toRef, watch, provide, openBlock, createBlock, unref, normalizeClass, withCtx, createVNode, renderSlot, createTextVNode, toDisplayString, createElementVNode, createCommentVNode, withDirectives, createElementBlock, normalizeStyle, vShow, nextTick } from "vue";
import { i as isBoundary, d as isRootBoundary, e as resolveFloatingPlacement, f as flip, s as shift, g as size, h as useFloating, z, o as offset } from "./floatingUi-DkjyEWfi.mjs";
import { o as onKeyStroke, d as onClickOutside } from "./index-DngH9Pjm.mjs";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { u as useId } from "./useId-SLUTyEVA.mjs";
import { a as BvTriggerableEvent } from "./classes-IC0yVJlq.mjs";
import { _ as _sfc_main$2 } from "./BButton.vue_vue_type_script_setup_true_lang-DUrERyIC.mjs";
import { _ as _sfc_main$1 } from "./ConditionalWrapper.vue_vue_type_script_lang-B-0cSyYg.mjs";
import { _ as _sfc_main$3 } from "./ConditionalTeleport.vue_vue_type_script_lang-CBHk9gJ3.mjs";
import { i as inputGroupKey, e as dropdownInjectionKey } from "./keys-DuZp76_V.mjs";
import { u as useToNumber } from "./index-DlGgXMQF.mjs";
const _hoisted_1 = { class: "visually-hidden" };
const _hoisted_2 = ["aria-labelledby", "role"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BDropdown",
  props: /* @__PURE__ */ mergeModels({
    ariaLabel: { default: void 0 },
    autoClose: { type: [Boolean, String], default: true },
    boundary: { default: "clippingAncestors" },
    boundaryPadding: { default: void 0 },
    center: { type: Boolean, default: false },
    disabled: { type: Boolean, default: false },
    dropend: { type: Boolean, default: false },
    dropstart: { type: Boolean, default: false },
    dropup: { type: Boolean, default: false },
    end: { type: Boolean, default: false },
    floatingMiddleware: { default: void 0 },
    id: { default: void 0 },
    isNav: { type: Boolean, default: false },
    lazy: { type: Boolean, default: false },
    menuClass: { default: void 0 },
    noCaret: { type: Boolean, default: false },
    noFlip: { type: Boolean, default: false },
    noShift: { type: Boolean, default: false },
    noSize: { type: Boolean, default: false },
    offset: { default: 0 },
    role: { default: "menu" },
    size: { default: "md" },
    skipWrapper: { type: Boolean, default: false },
    split: { type: Boolean, default: false },
    splitButtonType: { default: "button" },
    splitClass: { default: void 0 },
    splitDisabled: { type: Boolean, default: void 0 },
    splitHref: { default: void 0 },
    splitTo: { default: void 0 },
    splitVariant: { default: void 0 },
    strategy: { default: "absolute" },
    text: { default: void 0 },
    toggleClass: { default: void 0 },
    toggleText: { default: "Toggle dropdown" },
    variant: { default: "secondary" },
    wrapperClass: { default: void 0 },
    teleportDisabled: { type: Boolean, default: false },
    teleportTo: { default: void 0 }
  }, {
    "modelValue": { type: Boolean, ...{ default: false } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["click", "hidden", "hide", "hide-prevented", "show", "show-prevented", "shown", "toggle"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BDropdown");
    const emit = __emit;
    const computedId = useId(() => props.id, "dropdown");
    const modelValue = useModel(__props, "modelValue");
    const inInputGroup = inject(inputGroupKey, false);
    const computedOffset = computed(
      () => typeof props.offset === "string" || typeof props.offset === "number" ? props.offset : NaN
    );
    const offsetToNumber = useToNumber(computedOffset);
    const floating = ref(null);
    const button = ref(null);
    const splitButton = ref(null);
    const wrapper = ref(null);
    const boundary = computed(
      () => isBoundary(props.boundary) ? props.boundary : void 0
    );
    const rootBoundary = computed(
      () => isRootBoundary(props.boundary) ? props.boundary : void 0
    );
    const referencePlacement = computed(() => !props.split ? splitButton.value : button.value);
    onKeyStroke(
      "Escape",
      () => {
        modelValue.value = !modelValue.value;
      },
      { target: referencePlacement }
    );
    onKeyStroke(
      "Escape",
      () => {
        modelValue.value = !modelValue.value;
      },
      { target: floating }
    );
    const keynav = (e, v) => {
      var _a, _b, _c, _d, _e, _f, _g;
      if ((_b = floating.value) == null ? void 0 : _b.contains((_a = e.target) == null ? void 0 : _a.closest("form"))) return;
      if (/input|select|option|textarea|form/i.test((_c = e.target) == null ? void 0 : _c.tagName)) return;
      e.preventDefault();
      if (!modelValue.value) {
        open();
        nextTick(() => keynav(e, v));
        return;
      }
      const list = (_d = floating.value) == null ? void 0 : _d.querySelectorAll(".dropdown-item:not(.disabled):not(:disabled)");
      if (!list) return;
      if ((_e = floating.value) == null ? void 0 : _e.contains(document.activeElement)) {
        const active = floating.value.querySelector(".dropdown-item:focus");
        const index = Array.prototype.indexOf.call(list, active) + v;
        if (index >= 0 && index < (list == null ? void 0 : list.length)) (_f = list[index]) == null ? void 0 : _f.focus();
      } else {
        (_g = list[v === -1 ? list.length - 1 : 0]) == null ? void 0 : _g.focus();
      }
    };
    onKeyStroke("ArrowUp", (e) => keynav(e, -1), { target: referencePlacement });
    onKeyStroke("ArrowDown", (e) => keynav(e, 1), { target: referencePlacement });
    onKeyStroke("ArrowUp", (e) => keynav(e, -1), { target: floating });
    onKeyStroke("ArrowDown", (e) => keynav(e, 1), { target: floating });
    const floatingPlacement = computed(
      () => resolveFloatingPlacement({
        top: props.dropup,
        start: props.dropstart,
        end: props.dropend,
        alignCenter: props.center,
        alignEnd: props.end
      })
    );
    const sizeStyles = ref({});
    const floatingMiddleware = computed(() => {
      if (props.floatingMiddleware !== void 0) {
        return props.floatingMiddleware;
      }
      const localOffset = typeof props.offset === "string" || typeof props.offset === "number" ? offsetToNumber.value : props.offset;
      const arr = [offset(localOffset)];
      if (props.noFlip === false) {
        arr.push(
          flip({
            boundary: boundary.value,
            rootBoundary: rootBoundary.value,
            padding: props.boundaryPadding
          })
        );
      }
      if (props.noShift === false) {
        arr.push(
          shift({
            boundary: boundary.value,
            rootBoundary: rootBoundary.value,
            padding: props.boundaryPadding
          })
        );
      }
      if (props.noSize === false) {
        arr.push(
          size({
            boundary: boundary.value,
            rootBoundary: rootBoundary.value,
            padding: props.boundaryPadding,
            apply({ availableWidth, availableHeight }) {
              sizeStyles.value = {
                maxHeight: availableHeight && modelValue.value ? `${availableHeight}px` : void 0,
                maxWidth: availableWidth && modelValue.value ? `${availableWidth}px` : void 0
              };
            }
          })
        );
      }
      return arr;
    });
    const { update, floatingStyles } = useFloating(referencePlacement, floating, {
      placement: floatingPlacement,
      middleware: floatingMiddleware,
      strategy: toRef(() => props.strategy),
      whileElementsMounted: z
    });
    const computedClasses = computed(() => [
      props.wrapperClass,
      {
        "btn-group": !props.wrapperClass && props.split,
        "dropdown": !props.wrapperClass && !props.split,
        "dropup": props.dropup,
        "dropend": props.dropend,
        "dropstart": props.dropstart,
        "position-static": props.boundary !== "clippingAncestors" && !props.isNav
      }
    ]);
    const buttonClasses = computed(() => [
      props.split ? props.splitClass : props.toggleClass,
      {
        "nav-link": props.isNav,
        "dropdown-toggle": !props.split,
        "dropdown-toggle-no-caret": props.noCaret && !props.split,
        "show": props.split ? void 0 : modelValue.value
      }
    ]);
    const onButtonClick = () => {
      toggle();
    };
    const onSplitClick = (event) => {
      props.split ? emit("click", event) : onButtonClick();
    };
    onClickOutside(
      floating,
      () => {
        if (modelValue.value && (props.autoClose === true || props.autoClose === "outside")) {
          toggle();
        }
      },
      { ignore: [button, splitButton] }
    );
    const onClickInside = () => {
      if (modelValue.value && (props.autoClose === true || props.autoClose === "inside")) {
        toggle();
      }
    };
    const hide = () => {
      modelValue.value && toggle();
    };
    const show = () => {
      modelValue.value || toggle();
    };
    const toggle = () => {
      var _a, _b;
      emit("toggle");
      const currentModelValue = modelValue.value;
      const e = new BvTriggerableEvent(currentModelValue ? "hide" : "show");
      currentModelValue ? emit("hide", e) : emit("show", e);
      if (e.defaultPrevented) {
        currentModelValue ? emit("hide-prevented") : emit("show-prevented");
        return;
      }
      modelValue.value = !currentModelValue;
      currentModelValue ? emit("hidden") : emit("shown");
      (_b = (_a = wrapper.value) == null ? void 0 : _a.dispatchEvent) == null ? void 0 : _b.call(_a, new Event("forceHide"));
    };
    watch(modelValue, () => {
      update();
    });
    __expose({
      hide,
      show,
      toggle
    });
    provide(dropdownInjectionKey, {
      id: computedId,
      show,
      hide,
      toggle,
      visible: toRef(() => modelValue.value),
      isNav: toRef(() => props.isNav)
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$1, {
        ref_key: "wrapper",
        ref: wrapper,
        skip: unref(inInputGroup) || unref(props).skipWrapper,
        class: normalizeClass(computedClasses.value)
      }, {
        default: withCtx(() => [
          createVNode(_sfc_main$2, {
            id: unref(computedId),
            ref_key: "splitButton",
            ref: splitButton,
            variant: unref(props).splitVariant || unref(props).variant,
            size: unref(props).size,
            class: normalizeClass(buttonClasses.value),
            disabled: unref(props).splitDisabled || unref(props).disabled,
            type: unref(props).splitButtonType,
            "aria-label": unref(props).ariaLabel,
            "aria-expanded": unref(props).split ? void 0 : modelValue.value,
            "aria-haspopup": unref(props).split ? void 0 : "menu",
            href: unref(props).split ? unref(props).splitHref : void 0,
            to: unref(props).split && unref(props).splitTo ? unref(props).splitTo : void 0,
            onClick: onSplitClick
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "button-content", {}, () => [
                createTextVNode(toDisplayString(unref(props).text), 1)
              ])
            ]),
            _: 3
          }, 8, ["id", "variant", "size", "class", "disabled", "type", "aria-label", "aria-expanded", "aria-haspopup", "href", "to"]),
          unref(props).split ? (openBlock(), createBlock(_sfc_main$2, {
            key: 0,
            ref_key: "button",
            ref: button,
            variant: unref(props).variant,
            size: unref(props).size,
            disabled: unref(props).disabled,
            class: normalizeClass([[unref(props).toggleClass, { show: modelValue.value }], "dropdown-toggle-split dropdown-toggle"]),
            "aria-expanded": modelValue.value,
            "aria-haspopup": "menu",
            onClick: onButtonClick
          }, {
            default: withCtx(() => [
              createElementVNode("span", _hoisted_1, [
                renderSlot(_ctx.$slots, "toggle-text", {}, () => [
                  createTextVNode(toDisplayString(unref(props).toggleText), 1)
                ])
              ])
            ]),
            _: 3
          }, 8, ["variant", "size", "disabled", "class", "aria-expanded"])) : createCommentVNode("", true),
          createVNode(_sfc_main$3, {
            to: unref(props).teleportTo,
            disabled: !unref(props).teleportTo || unref(props).teleportDisabled
          }, {
            default: withCtx(() => [
              !unref(props).lazy || modelValue.value ? withDirectives((openBlock(), createElementBlock("ul", {
                key: 0,
                ref_key: "floating",
                ref: floating,
                style: normalizeStyle([unref(floatingStyles), sizeStyles.value]),
                class: normalizeClass(["dropdown-menu overflow-auto", [unref(props).menuClass, { show: modelValue.value }]]),
                "aria-labelledby": unref(computedId),
                role: unref(props).role,
                onClick: onClickInside
              }, [
                renderSlot(_ctx.$slots, "default", {
                  hide,
                  show
                })
              ], 14, _hoisted_2)), [
                [vShow, unref(props).lazy || modelValue.value]
              ]) : createCommentVNode("", true)
            ]),
            _: 3
          }, 8, ["to", "disabled"])
        ]),
        _: 3
      }, 8, ["skip", "class"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BDropdown.vue_vue_type_script_setup_true_lang-DHJEJkfU.mjs.map
