import { defineComponent, mergeModels, useSlots, useModel, inject, ref, computed, openBlock, createBlock, normalizeClass, unref, withCtx, withDirectives, createElementVNode, mergeProps, vModelRadio, createElementBlock, renderSlot, createCommentVNode, provide, toRef, Fragment, renderList, createTextVNode, toDisplayString } from "vue";
import { l as radioGroupKey } from "./keys-DuZp76_V.mjs";
import { e as useFocus } from "./index-DngH9Pjm.mjs";
import { g as getClasses, a as getInputClasses, b as getLabelClasses, c as getGroupAttr, d as getGroupClasses } from "./useFormCheck-Bcx8Ea7M.mjs";
import { i as isEmptySlot } from "./dom-B-SQyhbA.mjs";
import { _ as _sfc_main$2 } from "./ConditionalWrapper.vue_vue_type_script_lang-B-0cSyYg.mjs";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { u as useId } from "./useId-SLUTyEVA.mjs";
const _hoisted_1$1 = ["id", "disabled", "required", "name", "form", "aria-label", "aria-labelledby", "value", "aria-required"];
const _hoisted_2$1 = ["for"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BFormRadio",
  props: /* @__PURE__ */ mergeModels({
    ariaLabel: { default: void 0 },
    ariaLabelledby: { default: void 0 },
    autofocus: { type: Boolean, default: false },
    button: { type: Boolean, default: false },
    buttonGroup: { type: Boolean, default: false },
    buttonVariant: { default: null },
    disabled: { type: Boolean, default: false },
    form: { default: void 0 },
    id: { default: void 0 },
    inline: { type: Boolean, default: false },
    name: { default: void 0 },
    plain: { type: Boolean, default: false },
    required: { type: Boolean, default: false },
    reverse: { type: Boolean, default: false },
    size: { default: void 0 },
    state: { type: [Boolean, null], default: null },
    value: { type: [Boolean, String, Array, Object, Number, null], default: true }
  }, {
    "modelValue": { type: [Boolean, String, Array, Object, Number, null], ...{
      default: void 0
    } },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BFormRadio");
    const slots = useSlots();
    const modelValue = useModel(__props, "modelValue");
    const computedId = useId(() => props.id, "form-check");
    const parentData = inject(radioGroupKey, null);
    const input = ref(null);
    const { focused } = useFocus(input, {
      initialValue: props.autofocus
    });
    const hasDefaultSlot = computed(() => !isEmptySlot(slots.default));
    const localValue = computed({
      get: () => parentData ? parentData.modelValue.value : modelValue.value,
      set: (newValue) => {
        if (newValue === void 0) return;
        if (parentData !== null) {
          parentData.modelValue.value = newValue;
          return;
        }
        modelValue.value = newValue;
      }
    });
    const computedRequired = computed(
      () => !!(props.name ?? (parentData == null ? void 0 : parentData.name.value)) && (props.required || (parentData == null ? void 0 : parentData.required.value))
    );
    const isButtonGroup = computed(() => props.buttonGroup || ((parentData == null ? void 0 : parentData.buttons.value) ?? false));
    const classesObject = computed(() => ({
      plain: props.plain || ((parentData == null ? void 0 : parentData.plain.value) ?? false),
      button: props.button || ((parentData == null ? void 0 : parentData.buttons.value) ?? false),
      inline: props.inline || ((parentData == null ? void 0 : parentData.inline.value) ?? false),
      state: props.state || (parentData == null ? void 0 : parentData.state.value),
      reverse: props.reverse || ((parentData == null ? void 0 : parentData.reverse.value) ?? false),
      size: props.size ?? (parentData == null ? void 0 : parentData.size.value) ?? "md",
      // This is where the true default is made
      buttonVariant: props.buttonVariant ?? (parentData == null ? void 0 : parentData.buttonVariant.value) ?? "secondary",
      // This is where the true default is made
      hasDefaultSlot: hasDefaultSlot.value
    }));
    const computedClasses = getClasses(classesObject);
    const inputClasses = getInputClasses(classesObject);
    const labelClasses = getLabelClasses(classesObject);
    __expose({
      blur: () => {
        focused.value = false;
      },
      element: input,
      focus: () => {
        focused.value = true;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$2, {
        skip: isButtonGroup.value,
        class: normalizeClass(unref(computedClasses))
      }, {
        default: withCtx(() => {
          var _a, _b, _c;
          return [
            withDirectives(createElementVNode("input", mergeProps({ id: unref(computedId) }, _ctx.$attrs, {
              ref_key: "input",
              ref: input,
              "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => localValue.value = $event),
              class: unref(inputClasses),
              type: "radio",
              disabled: unref(props).disabled || ((_a = unref(parentData)) == null ? void 0 : _a.disabled.value),
              required: computedRequired.value || void 0,
              name: unref(props).name || ((_b = unref(parentData)) == null ? void 0 : _b.name.value),
              form: unref(props).form || ((_c = unref(parentData)) == null ? void 0 : _c.form.value),
              "aria-label": unref(props).ariaLabel,
              "aria-labelledby": unref(props).ariaLabelledby,
              value: unref(props).value,
              "aria-required": computedRequired.value || void 0
            }), null, 16, _hoisted_1$1), [
              [vModelRadio, localValue.value]
            ]),
            hasDefaultSlot.value || unref(props).plain === false ? (openBlock(), createElementBlock("label", {
              key: 0,
              for: unref(computedId),
              class: normalizeClass(unref(labelClasses))
            }, [
              renderSlot(_ctx.$slots, "default")
            ], 10, _hoisted_2$1)) : createCommentVNode("", true)
          ];
        }),
        _: 3
      }, 8, ["skip", "class"]);
    };
  }
});
const _hoisted_1 = ["id"];
const _hoisted_2 = ["innerHTML"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormRadioGroup",
  props: /* @__PURE__ */ mergeModels({
    ariaInvalid: { type: [Boolean, String], default: void 0 },
    autofocus: { type: Boolean, default: false },
    buttonVariant: { default: "secondary" },
    buttons: { type: Boolean, default: false },
    disabled: { type: Boolean, default: false },
    disabledField: { default: "disabled" },
    form: { default: void 0 },
    htmlField: { default: "html" },
    id: { default: void 0 },
    name: { default: void 0 },
    options: { default: () => [] },
    plain: { type: Boolean, default: false },
    required: { type: Boolean, default: false },
    reverse: { type: Boolean, default: false },
    size: { default: "md" },
    stacked: { type: Boolean, default: false },
    state: { type: [Boolean, null], default: null },
    textField: { default: "text" },
    validated: { type: Boolean, default: false },
    valueField: { default: "value" }
  }, {
    "modelValue": {
      default: null
    },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BFormRadioGroup");
    const modelValue = useModel(__props, "modelValue");
    const computedId = useId(() => props.id, "radio");
    const computedName = useId(() => props.name, "checkbox");
    const element = ref(null);
    const { focused } = useFocus(element, {
      initialValue: props.autofocus
    });
    provide(radioGroupKey, {
      modelValue,
      buttonVariant: toRef(() => props.buttonVariant),
      form: toRef(() => props.form),
      name: computedName,
      buttons: toRef(() => props.buttons),
      state: toRef(() => props.state),
      plain: toRef(() => props.plain),
      size: toRef(() => props.size),
      inline: toRef(() => !props.stacked),
      reverse: toRef(() => props.reverse),
      required: toRef(() => props.required),
      disabled: toRef(() => props.disabled)
    });
    const normalizeOptions = computed(
      () => props.options.map(
        (el, ind) => typeof el === "string" || typeof el === "number" ? {
          value: el,
          disabled: props.disabled,
          text: el.toString(),
          html: void 0,
          self: Symbol(`radioGroupOptionItem${ind}`)
        } : {
          value: el[props.valueField],
          disabled: el[props.disabledField],
          ...el.props ? el.props : {},
          text: el[props.textField],
          html: el[props.htmlField],
          self: Symbol(`radioGroupOptionItem${ind}`)
        }
      )
    );
    const classesObject = computed(() => ({
      required: props.required,
      ariaInvalid: props.ariaInvalid,
      state: props.state,
      validated: props.validated,
      buttons: props.buttons,
      stacked: props.stacked,
      size: props.size
    }));
    const computedAttrs = getGroupAttr(classesObject);
    const computedClasses = getGroupClasses(classesObject);
    __expose({
      blur: () => {
        focused.value = false;
      },
      focus: () => {
        focused.value = true;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", mergeProps(unref(computedAttrs), {
        id: unref(computedId),
        ref_key: "element",
        ref: element,
        role: "radiogroup",
        class: [unref(computedClasses), "bv-no-focus-ring"],
        tabindex: "-1"
      }), [
        renderSlot(_ctx.$slots, "first"),
        (openBlock(true), createElementBlock(Fragment, null, renderList(normalizeOptions.value, (item) => {
          return openBlock(), createBlock(_sfc_main$1, {
            key: item.self,
            disabled: item.disabled,
            value: item.value
          }, {
            default: withCtx(() => [
              !!item.html ? (openBlock(), createElementBlock("span", {
                key: 0,
                innerHTML: item.html
              }, null, 8, _hoisted_2)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                createTextVNode(toDisplayString(item.text), 1)
              ], 64))
            ]),
            _: 2
          }, 1032, ["disabled", "value"]);
        }), 128)),
        renderSlot(_ctx.$slots, "default")
      ], 16, _hoisted_1);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BFormRadioGroup.vue_vue_type_script_setup_true_lang-DN3wYGro.mjs.map
