import { defineComponent, mergeModels, useModel, computed, openBlock, createElementBlock, unref, normalizeClass, normalizeStyle } from "vue";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { n as normalizeInput, u as useFormInput } from "./useFormInput-CZyKrNfp.mjs";
import { u as useStateClass } from "./useStateClass-BGbSLWFN.mjs";
const _hoisted_1 = ["id", "name", "form", "value", "disabled", "placeholder", "required", "autocomplete", "readonly", "aria-required", "aria-invalid", "rows", "wrap"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormTextarea",
  props: /* @__PURE__ */ mergeModels({
    noResize: { type: Boolean, default: false },
    rows: { default: 2 },
    wrap: { default: "soft" },
    ariaInvalid: { type: [Boolean, String], default: void 0 },
    autocomplete: { default: void 0 },
    autofocus: { type: Boolean, default: false },
    disabled: { type: Boolean, default: false },
    form: { default: void 0 },
    formatter: { type: Function, default: void 0 },
    id: { default: void 0 },
    lazyFormatter: { type: Boolean, default: false },
    list: { default: void 0 },
    name: { default: void 0 },
    placeholder: { default: void 0 },
    plaintext: { type: Boolean, default: false },
    readonly: { type: Boolean, default: false },
    required: { type: Boolean, default: false },
    size: { default: void 0 },
    state: { type: [Boolean, null], default: null },
    debounce: { default: 0 },
    debounceMaxWait: { default: NaN }
  }, {
    "modelValue": {
      default: ""
    },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BFormTextarea");
    const [modelValue, modelModifiers] = useModel(__props, "modelValue", {
      set: (v) => normalizeInput(v, modelModifiers)
    });
    const { input, computedId, computedAriaInvalid, onInput, onChange, onBlur, focus, blur } = useFormInput(props, modelValue, modelModifiers);
    const stateClass = useStateClass(() => props.state);
    const computedClasses = computed(() => [
      stateClass.value,
      props.plaintext ? "form-control-plaintext" : "form-control",
      {
        [`form-control-${props.size}`]: !!props.size
      }
    ]);
    const computedStyles = computed(() => ({
      resize: props.noResize ? "none" : void 0
    }));
    __expose({
      blur,
      element: input,
      focus
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("textarea", {
        id: unref(computedId),
        ref_key: "input",
        ref: input,
        class: normalizeClass(computedClasses.value),
        name: unref(props).name || void 0,
        form: unref(props).form || void 0,
        value: unref(modelValue) ?? void 0,
        disabled: unref(props).disabled,
        placeholder: unref(props).placeholder,
        required: unref(props).required || void 0,
        autocomplete: unref(props).autocomplete || void 0,
        readonly: unref(props).readonly || unref(props).plaintext,
        "aria-required": unref(props).required || void 0,
        "aria-invalid": unref(computedAriaInvalid),
        rows: unref(props).rows,
        style: normalizeStyle(computedStyles.value),
        wrap: unref(props).wrap || void 0,
        onInput: _cache[0] || (_cache[0] = ($event) => unref(onInput)($event)),
        onChange: _cache[1] || (_cache[1] = ($event) => unref(onChange)($event)),
        onBlur: _cache[2] || (_cache[2] = ($event) => unref(onBlur)($event))
      }, null, 46, _hoisted_1);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BFormTextarea.vue_vue_type_script_setup_true_lang-DuQL-FCJ.mjs.map
