import { defineComponent, computed, provide, toRef, openBlock, createBlock, resolveDynamicComponent, normalizeClass, withCtx, renderSlot, useAttrs, inject, mergeProps, unref } from "vue";
import { o as listGroupInjectionKey } from "./keys-DuZp76_V.mjs";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { _ as _sfc_main$2 } from "./BLink.vue_vue_type_script_setup_true_lang-DS4JR4ch.mjs";
import { u as useBLinkHelper } from "./useBLinkHelper-Bvtov_sk.mjs";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BListGroup",
  props: {
    flush: { type: Boolean, default: false },
    horizontal: { type: [Boolean, String], default: false },
    numbered: { type: Boolean, default: false },
    tag: { default: "div" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BListGroup");
    const computedClasses = computed(() => {
      const horizontal = props.flush ? false : props.horizontal;
      return {
        "list-group-flush": props.flush,
        "list-group-horizontal": horizontal === true,
        [`list-group-horizontal-${horizontal}`]: typeof horizontal === "string",
        "list-group-numbered": props.numbered
      };
    });
    const computedTag = computed(() => props.numbered === true ? "ol" : props.tag);
    provide(listGroupInjectionKey, {
      numbered: toRef(() => props.numbered)
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(computedTag.value), {
        class: normalizeClass(["list-group", computedClasses.value])
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BListGroupItem",
  props: {
    action: { type: Boolean, default: false },
    button: { type: Boolean, default: false },
    tag: { default: "div" },
    active: { type: Boolean, default: false },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: void 0 },
    href: { default: void 0 },
    icon: { type: Boolean, default: void 0 },
    noRel: { type: Boolean },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: void 0 },
    variant: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BListGroupItem");
    const attrs = useAttrs();
    const parentData = inject(listGroupInjectionKey, null);
    const { computedLink } = useBLinkHelper(props);
    const isLink = computed(() => !props.button && computedLink.value);
    const tagComputed = computed(
      () => (parentData == null ? void 0 : parentData.numbered.value) ? "li" : props.button ? "button" : !isLink.value ? props.tag : _sfc_main$2
    );
    const isAction = computed(
      () => props.action || isLink.value || props.button || ["a", "router-link", "button", "b-link"].includes(props.tag)
    );
    const computedClasses = computed(() => ({
      [`list-group-item-${props.variant}`]: props.variant !== null && props.variant !== void 0,
      "list-group-item-action": isAction.value,
      "active": props.active,
      "disabled": props.disabled
    }));
    const computedAttrs = computed(() => {
      const localAttrs = {};
      if (props.button) {
        if (!attrs || !attrs.type) {
          localAttrs.type = "button";
        }
        if (props.disabled) {
          localAttrs.disabled = true;
        }
      }
      return localAttrs;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(tagComputed.value), mergeProps({
        class: ["list-group-item", computedClasses.value],
        "aria-current": unref(props).active ? true : void 0,
        "aria-disabled": unref(props).disabled ? true : void 0,
        target: isLink.value ? unref(props).target : void 0,
        href: !unref(props).button ? unref(props).href : void 0,
        to: !unref(props).button ? unref(props).to : void 0
      }, computedAttrs.value), {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 16, ["class", "aria-current", "aria-disabled", "target", "href", "to"]);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BListGroupItem.vue_vue_type_script_setup_true_lang-DjbTQWnl.mjs.map
