import { computed, toValue, defineComponent, mergeModels, useSlots, useModel, ref, watch, openBlock, createBlock, unref, withCtx, createVNode, Transition, mergeProps, withDirectives, createElementVNode, normalizeClass, createElementBlock, renderSlot, normalizeProps, guardReactiveProps, resolveDynamicComponent, createTextVNode, toDisplayString, Fragment, createCommentVNode, vShow, renderList } from "vue";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { o as onKeyStroke, e as useFocus, c as useEventListener } from "./index-DngH9Pjm.mjs";
import { a as useActivatedFocusTrap, u as useSafeScrollLock } from "./useSafeScrollLock-BAPMIjjV.mjs";
import { a as BvTriggerableEvent } from "./classes-IC0yVJlq.mjs";
import { _ as _sfc_main$3 } from "./BButton.vue_vue_type_script_setup_true_lang-DUrERyIC.mjs";
import { _ as _sfc_main$4 } from "./BCloseButton.vue_vue_type_script_setup_true_lang-B_GsCJs6.mjs";
import { u as useId } from "./useId-SLUTyEVA.mjs";
import { i as isEmptySlot } from "./dom-B-SQyhbA.mjs";
import { u as useColorVariantClasses } from "./useColorVariantClasses-ZDE19TZw.mjs";
import { a as useModalManager } from "./useModalManager-B5E0Qeku.mjs";
import { _ as _sfc_main$2 } from "./ConditionalTeleport.vue_vue_type_script_lang-CBHk9gJ3.mjs";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.mjs";
import { useModalController } from "./src/composables/useModalController/index.mjs";
const useFadeTransition = (noFade) => computed(() => {
  const NO_FADE_PROPS = {
    name: "",
    enterActiveClass: "",
    enterToClass: "",
    leaveActiveClass: "",
    leaveToClass: "showing",
    enterFromClass: "showing",
    leaveFromClass: "",
    css: true
  };
  const FADE_PROPS = {
    ...NO_FADE_PROPS,
    name: "fade",
    enterActiveClass: "fade showing",
    leaveActiveClass: "fade showing"
  };
  return toValue(noFade) ? NO_FADE_PROPS : FADE_PROPS;
});
const _hoisted_1 = ["id", "aria-labelledby", "aria-describedby"];
const _hoisted_2 = ["id"];
const fallbackClassSelector = "modal-fallback-focus";
const defaultModalDialogZIndex = 1056;
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BModal",
  props: /* @__PURE__ */ mergeModels({
    autofocus: { type: Boolean, default: true },
    autofocusButton: { default: void 0 },
    body: { default: void 0 },
    bodyAttrs: { default: void 0 },
    bodyBgVariant: { default: null },
    bodyClass: { default: null },
    bodyScrolling: { type: Boolean, default: false },
    bodyTextVariant: { default: null },
    bodyVariant: { default: null },
    busy: { type: Boolean, default: false },
    buttonSize: { default: "md" },
    cancelDisabled: { type: Boolean, default: false },
    cancelTitle: { default: "Cancel" },
    cancelVariant: { default: "secondary" },
    centered: { type: Boolean, default: false },
    contentClass: { default: void 0 },
    dialogClass: { default: void 0 },
    footerBgVariant: { default: null },
    footerBorderVariant: { default: null },
    footerClass: { default: void 0 },
    footerTextVariant: { default: null },
    footerVariant: { default: null },
    fullscreen: { type: [Boolean, String], default: false },
    headerBgVariant: { default: null },
    headerBorderVariant: { default: null },
    headerClass: { default: void 0 },
    headerCloseClass: { default: void 0 },
    headerCloseLabel: { default: "Close" },
    headerCloseVariant: { default: "secondary" },
    headerTextVariant: { default: null },
    headerVariant: { default: null },
    hideBackdrop: { type: Boolean, default: false },
    hideFooter: { type: Boolean, default: false },
    hideHeader: { type: Boolean, default: false },
    hideHeaderClose: { type: Boolean, default: false },
    id: { default: void 0 },
    lazy: { type: Boolean, default: false },
    modalClass: { default: void 0 },
    noCloseOnBackdrop: { type: Boolean, default: false },
    noCloseOnEsc: { type: Boolean, default: false },
    noFade: { type: Boolean, default: false },
    noTrap: { type: Boolean, default: false },
    noStacking: { type: Boolean },
    okDisabled: { type: Boolean, default: false },
    okOnly: { type: Boolean, default: false },
    okTitle: { default: "OK" },
    okVariant: { default: "primary" },
    scrollable: { type: Boolean, default: false },
    size: { default: "md" },
    title: { default: void 0 },
    titleClass: { default: void 0 },
    titleSrOnly: { type: Boolean, default: false },
    titleTag: { default: "h5" },
    transProps: { default: void 0 },
    teleportDisabled: { type: Boolean, default: false },
    teleportTo: { default: "body" }
  }, {
    "modelValue": { type: Boolean, ...{ default: false } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["backdrop", "cancel", "close", "esc", "hidden", "hide", "hide-prevented", "ok", "show", "show-prevented", "shown"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BModal");
    const emit = __emit;
    const slots = useSlots();
    const computedId = useId(() => props.id, "modal");
    const modelValue = useModel(__props, "modelValue");
    const element = ref(null);
    const fallbackFocusElement = ref(null);
    const okButton = ref(null);
    const cancelButton = ref(null);
    const closeButton = ref(null);
    const isActive = ref(false);
    const lazyLoadCompleted = ref(false);
    const { needsFallback } = useActivatedFocusTrap({
      element,
      isActive,
      noTrap: () => props.noTrap,
      fallbackFocus: {
        ref: fallbackFocusElement,
        classSelector: fallbackClassSelector
      }
    });
    const fadeTransitionProps = useFadeTransition(true);
    onKeyStroke(
      "Escape",
      () => {
        hideFn("esc");
      },
      { target: element }
    );
    useSafeScrollLock(modelValue, () => props.bodyScrolling);
    const { focused: modalFocus } = useFocus(element, {
      initialValue: modelValue.value && props.autofocusButton === void 0 && props.autofocus === true
    });
    const { focused: okButtonFocus } = useFocus(okButton, {
      initialValue: modelValue.value && props.autofocusButton === "ok" && props.autofocus === true
    });
    const { focused: cancelButtonFocus } = useFocus(cancelButton, {
      initialValue: modelValue.value && props.autofocusButton === "cancel" && props.autofocus === true
    });
    const { focused: closeButtonFocus } = useFocus(closeButton, {
      initialValue: modelValue.value && props.autofocusButton === "close" && props.autofocus === true
    });
    const modalClasses = computed(() => [
      props.modalClass,
      {
        fade: !props.noFade,
        show: isActive.value
      }
    ]);
    const lazyShowing = computed(
      () => props.lazy === false || props.lazy === true && lazyLoadCompleted.value === true || props.lazy === true && modelValue.value === true
    );
    const hasHeaderCloseSlot = computed(() => !isEmptySlot(slots["header-close"]));
    const modalDialogClasses = computed(() => [
      props.dialogClass,
      {
        "modal-fullscreen": props.fullscreen === true,
        [`modal-fullscreen-${props.fullscreen}-down`]: typeof props.fullscreen === "string",
        [`modal-${props.size}`]: props.size !== "md",
        "modal-dialog-centered": props.centered,
        "modal-dialog-scrollable": props.scrollable
      }
    ]);
    const bodyColorClasses = useColorVariantClasses(() => ({
      bgVariant: props.bodyBgVariant,
      textVariant: props.bodyTextVariant,
      variant: props.bodyVariant
    }));
    const bodyClasses = computed(() => [props.bodyClass, bodyColorClasses.value]);
    const headerColorClasses = useColorVariantClasses(() => ({
      bgVariant: props.headerBgVariant,
      textVariant: props.headerTextVariant,
      variant: props.headerVariant,
      borderVariant: props.headerBorderVariant
    }));
    const headerClasses = computed(() => [props.headerClass, headerColorClasses.value]);
    const headerCloseAttrs = computed(() => ({
      variant: hasHeaderCloseSlot.value ? props.headerCloseVariant : void 0,
      class: props.headerCloseClass
    }));
    const footerColorClasses = useColorVariantClasses(() => ({
      bgVariant: props.footerBgVariant,
      textVariant: props.footerTextVariant,
      variant: props.footerVariant,
      borderVariant: props.footerBorderVariant
    }));
    const footerClasses = computed(() => [props.footerClass, footerColorClasses.value]);
    const titleClasses = computed(() => [
      props.titleClass,
      {
        ["visually-hidden"]: props.titleSrOnly
      }
    ]);
    const disableCancel = computed(() => props.cancelDisabled || props.busy);
    const disableOk = computed(() => props.okDisabled || props.busy);
    const buildTriggerableEvent = (type, opts = {}) => new BvTriggerableEvent(type, {
      cancelable: false,
      target: element.value || null,
      relatedTarget: null,
      trigger: null,
      ...opts,
      componentId: computedId.value
    });
    watch(modelValue, (newValue, oldValue) => {
      if (newValue === oldValue) return;
      if (newValue === true) {
        showFn();
      } else {
        hideFn();
      }
    });
    const hideFn = (trigger = "") => {
      if (trigger === "backdrop" && props.noCloseOnBackdrop || trigger === "esc" && props.noCloseOnEsc) {
        emit("hide-prevented");
        return;
      }
      const event = buildTriggerableEvent("hide", { cancelable: trigger !== "", trigger });
      if (trigger === "ok") {
        emit(trigger, event);
      }
      if (trigger === "cancel") {
        emit(trigger, event);
      }
      if (trigger === "close") {
        emit(trigger, event);
      }
      if (trigger === "backdrop") {
        emit(trigger, event);
      }
      if (trigger === "esc") {
        emit(trigger, event);
      }
      emit("hide", event);
      if (event.defaultPrevented) {
        emit("hide-prevented");
        if (!modelValue.value) modelValue.value = true;
        return;
      }
      if (modelValue.value) modelValue.value = false;
    };
    const showFn = () => {
      if (isActive.value) return;
      const event = buildTriggerableEvent("show", { cancelable: true });
      emit("show", event);
      if (event.defaultPrevented) {
        if (modelValue.value) modelValue.value = false;
        emit("show-prevented");
        return;
      }
      if (!modelValue.value) modelValue.value = true;
    };
    const pickFocusItem = () => {
      if (props.autofocus === false) return;
      props.autofocusButton === "ok" ? okButtonFocus.value = true : props.autofocusButton === "close" ? closeButtonFocus.value = true : props.autofocusButton === "cancel" ? cancelButtonFocus.value = true : modalFocus.value = true;
    };
    const onBeforeEnter = () => {
      showFn();
    };
    const onAfterEnter = () => {
      isActive.value = true;
      pickFocusItem();
      emit("shown", buildTriggerableEvent("shown"));
      if (props.lazy === true) lazyLoadCompleted.value = true;
    };
    const isLeaving = ref(false);
    const onLeave = () => {
      isActive.value = false;
      isLeaving.value = true;
    };
    const onAfterLeave = () => {
      emit("hidden", buildTriggerableEvent("hidden"));
      if (props.lazy === true) lazyLoadCompleted.value = false;
      isLeaving.value = false;
    };
    const { activePosition, activeModalCount, stackWithoutSelf } = useModalManager(
      isActive,
      modelValue.value
    );
    watch(stackWithoutSelf, (newValue, oldValue) => {
      if (newValue.length > oldValue.length && isActive.value === true && props.noStacking === true)
        hideFn();
    });
    const computedZIndex = computed(() => ({
      // Make sure that newly opened modals have a higher z-index than currently active ones.
      // All active modals have a z-index of ('defaultZIndex' - 'stackSize' - 'positionInStack').
      //
      // This means inactive modals will already be higher than active ones when opened.
      "z-index": isActive.value || isLeaving.value ? (
        // Just for reference there is a single frame in which the modal is not active but still has a higher z-index than the active ones due to _when_ it calculates its position. It's a small visual effect
        defaultModalDialogZIndex - (((activeModalCount == null ? void 0 : activeModalCount.value) ?? 0) - ((activePosition == null ? void 0 : activePosition.value) ?? 0))
      ) : defaultModalDialogZIndex
    }));
    useEventListener(element, "bv-toggle", () => {
      modelValue.value ? hideFn() : showFn();
    });
    const sharedSlots = computed(() => ({
      cancel: () => {
        hideFn("cancel");
      },
      close: () => {
        hideFn("close");
      },
      hide: hideFn,
      ok: () => {
        hideFn("ok");
      },
      active: isActive.value,
      visible: modelValue.value
    }));
    __expose({
      hide: hideFn,
      id: computedId,
      show: showFn
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$2, {
        to: unref(props).teleportTo,
        disabled: unref(props).teleportDisabled
      }, {
        default: withCtx(() => [
          createVNode(Transition, mergeProps({ ...unref(fadeTransitionProps), ...unref(props).transProps, enterToClass: "show" }, {
            appear: modelValue.value,
            onBeforeEnter,
            onAfterEnter,
            onLeave,
            onAfterLeave
          }), {
            default: withCtx(() => [
              withDirectives(createElementVNode("div", mergeProps({
                id: unref(computedId),
                ref_key: "element",
                ref: element,
                class: ["modal", modalClasses.value],
                role: "dialog",
                "aria-labelledby": !unref(props).hideHeader ? `${unref(computedId)}-label` : void 0,
                "aria-describedby": `${unref(computedId)}-body`,
                tabindex: "-1"
              }, _ctx.$attrs, { style: computedZIndex.value }), [
                createElementVNode("div", {
                  class: normalizeClass(["modal-dialog", modalDialogClasses.value])
                }, [
                  lazyShowing.value ? (openBlock(), createElementBlock("div", {
                    key: 0,
                    class: normalizeClass(["modal-content", unref(props).contentClass])
                  }, [
                    !unref(props).hideHeader ? (openBlock(), createElementBlock("div", {
                      key: 0,
                      class: normalizeClass(["modal-header", headerClasses.value])
                    }, [
                      renderSlot(_ctx.$slots, "header", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                        (openBlock(), createBlock(resolveDynamicComponent(unref(props).titleTag), {
                          id: `${unref(computedId)}-label`,
                          class: normalizeClass(["modal-title", titleClasses.value])
                        }, {
                          default: withCtx(() => [
                            renderSlot(_ctx.$slots, "title", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                              createTextVNode(toDisplayString(unref(props).title), 1)
                            ], true)
                          ]),
                          _: 3
                        }, 8, ["id", "class"])),
                        !unref(props).hideHeaderClose ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                          hasHeaderCloseSlot.value ? (openBlock(), createBlock(_sfc_main$3, mergeProps({ key: 0 }, headerCloseAttrs.value, {
                            onClick: _cache[0] || (_cache[0] = ($event) => hideFn("close"))
                          }), {
                            default: withCtx(() => [
                              renderSlot(_ctx.$slots, "header-close", {}, void 0, true)
                            ]),
                            _: 3
                          }, 16)) : (openBlock(), createBlock(_sfc_main$4, mergeProps({
                            key: 1,
                            "aria-label": unref(props).headerCloseLabel
                          }, headerCloseAttrs.value, {
                            onClick: _cache[1] || (_cache[1] = ($event) => hideFn("close"))
                          }), null, 16, ["aria-label"]))
                        ], 64)) : createCommentVNode("", true)
                      ], true)
                    ], 2)) : createCommentVNode("", true),
                    createElementVNode("div", mergeProps({
                      id: `${unref(computedId)}-body`,
                      class: ["modal-body", bodyClasses.value]
                    }, unref(props).bodyAttrs), [
                      renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                        createTextVNode(toDisplayString(unref(props).body), 1)
                      ], true)
                    ], 16, _hoisted_2),
                    !unref(props).hideFooter ? (openBlock(), createElementBlock("div", {
                      key: 1,
                      class: normalizeClass(["modal-footer", footerClasses.value])
                    }, [
                      renderSlot(_ctx.$slots, "footer", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                        renderSlot(_ctx.$slots, "cancel", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                          !unref(props).okOnly ? (openBlock(), createBlock(_sfc_main$3, {
                            key: 0,
                            ref_key: "cancelButton",
                            ref: cancelButton,
                            disabled: disableCancel.value,
                            size: unref(props).buttonSize,
                            variant: unref(props).cancelVariant,
                            onClick: _cache[2] || (_cache[2] = ($event) => hideFn("cancel"))
                          }, {
                            default: withCtx(() => [
                              createTextVNode(toDisplayString(unref(props).cancelTitle), 1)
                            ]),
                            _: 1
                          }, 8, ["disabled", "size", "variant"])) : createCommentVNode("", true)
                        ], true),
                        renderSlot(_ctx.$slots, "ok", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                          createVNode(_sfc_main$3, {
                            ref_key: "okButton",
                            ref: okButton,
                            disabled: disableOk.value,
                            size: unref(props).buttonSize,
                            variant: unref(props).okVariant,
                            onClick: _cache[3] || (_cache[3] = ($event) => hideFn("ok"))
                          }, {
                            default: withCtx(() => [
                              createTextVNode(toDisplayString(unref(props).okTitle), 1)
                            ]),
                            _: 1
                          }, 8, ["disabled", "size", "variant"])
                        ], true)
                      ], true)
                    ], 2)) : createCommentVNode("", true)
                  ], 2)) : createCommentVNode("", true)
                ], 2),
                !unref(props).hideBackdrop ? renderSlot(_ctx.$slots, "backdrop", normalizeProps(mergeProps({ key: 0 }, sharedSlots.value)), () => [
                  createElementVNode("div", {
                    class: "modal-backdrop fade show",
                    onClick: _cache[4] || (_cache[4] = ($event) => hideFn("backdrop"))
                  })
                ], true) : createCommentVNode("", true),
                unref(needsFallback) ? (openBlock(), createElementBlock("div", {
                  key: 1,
                  ref_key: "fallbackFocusElement",
                  ref: fallbackFocusElement,
                  class: normalizeClass(fallbackClassSelector),
                  tabindex: "0",
                  style: { "width": "0", "height": "0", "overflow": "hidden" }
                }, null, 512)) : createCommentVNode("", true)
              ], 16, _hoisted_1), [
                [vShow, modelValue.value]
              ])
            ]),
            _: 3
          }, 16, ["appear"])
        ]),
        _: 3
      }, 8, ["to", "disabled"]);
    };
  }
});
const BModal = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["__scopeId", "data-v-b05df8ad"]]);
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BModalOrchestrator",
  props: {
    teleportDisabled: { type: Boolean, default: false },
    teleportTo: { default: "body" }
  },
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BModalOrchestrator");
    const tools = useModalController();
    __expose({
      ...tools
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$2, {
        to: unref(props).teleportTo,
        disabled: unref(props).teleportDisabled
      }, {
        default: withCtx(() => {
          var _a;
          return [
            createElementVNode("div", mergeProps({ id: "__BVID__modal-container" }, _ctx.$attrs), [
              (openBlock(true), createElementBlock(Fragment, null, renderList((_a = unref(tools).modals) == null ? void 0 : _a.value, ([self, modal]) => {
                return openBlock(), createBlock(resolveDynamicComponent(modal.component ?? BModal), mergeProps({
                  key: self,
                  ref_for: true
                }, modal.props, {
                  modelValue: modal.props._modelValue,
                  "onUpdate:modelValue": [($event) => modal.props._modelValue = $event, ($event) => {
                    var _a2, _b;
                    return (_b = (_a2 = unref(tools)).leave) == null ? void 0 : _b.call(_a2, self);
                  }],
                  "teleport-disabled": true,
                  onHide: (e) => {
                    if (modal.props._isConfirm === true) {
                      if (e.trigger === "ok") {
                        modal.props._promise.resolve(true);
                        return;
                      }
                      if (e.trigger === "cancel") {
                        modal.props._promise.resolve(false);
                        return;
                      }
                      modal.props._promise.resolve(null);
                    }
                    modal.props._promise.resolve(true);
                  },
                  onHidden: ($event) => {
                    var _a2, _b;
                    return (_b = (_a2 = unref(tools)).remove) == null ? void 0 : _b.call(_a2, self);
                  }
                }), null, 16, ["modelValue", "onUpdate:modelValue", "onHide", "onHidden"]);
              }), 128))
            ], 16)
          ];
        }),
        _: 1
      }, 8, ["to", "disabled"]);
    };
  }
});
export {
  BModal as B,
  _sfc_main as _
};
//# sourceMappingURL=BModalOrchestrator.vue_vue_type_script_setup_true_lang-DESSsMw4.mjs.map
