import { defineComponent, mergeModels, useSlots, useModel, computed, ref, watch, openBlock, createBlock, unref, withCtx, createVNode, Transition, mergeProps, withDirectives, createElementVNode, createElementBlock, Fragment, normalizeClass, renderSlot, normalizeProps, guardReactiveProps, createTextVNode, toDisplayString, createCommentVNode, vShow, nextTick } from "vue";
import { f as useBreakpoints, o as onKeyStroke, e as useFocus, c as useEventListener, g as breakpointsBootstrapV5 } from "./index-DngH9Pjm.mjs";
import { u as useSafeScrollLock, a as useActivatedFocusTrap } from "./useSafeScrollLock-BAPMIjjV.mjs";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { u as useId } from "./useId-SLUTyEVA.mjs";
import { a as BvTriggerableEvent } from "./classes-IC0yVJlq.mjs";
import { _ as _sfc_main$2 } from "./BButton.vue_vue_type_script_setup_true_lang-DUrERyIC.mjs";
import { _ as _sfc_main$3 } from "./BCloseButton.vue_vue_type_script_setup_true_lang-B_GsCJs6.mjs";
import { _ as _sfc_main$1 } from "./ConditionalTeleport.vue_vue_type_script_lang-CBHk9gJ3.mjs";
import { i as isEmptySlot } from "./dom-B-SQyhbA.mjs";
const _hoisted_1 = ["id", "aria-labelledby"];
const _hoisted_2 = ["id"];
const fallbackClassSelector = "offcanvas-fallback-focus";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BOffcanvas",
  props: /* @__PURE__ */ mergeModels({
    hideBackdrop: { type: Boolean, default: false },
    bodyAttrs: { default: void 0 },
    bodyClass: { default: void 0 },
    bodyScrolling: { type: Boolean, default: false },
    footerClass: { default: void 0 },
    headerClass: { default: void 0 },
    headerCloseClass: { default: void 0 },
    headerCloseLabel: { default: "Close" },
    headerCloseVariant: { default: "secondary" },
    id: { default: void 0 },
    lazy: { type: Boolean, default: false },
    noCloseOnBackdrop: { type: Boolean, default: false },
    noCloseOnEsc: { type: Boolean, default: false },
    noFocus: { type: Boolean, default: false },
    noHeader: { type: Boolean, default: false },
    noTrap: { type: Boolean, default: false },
    noHeaderClose: { type: Boolean, default: false },
    placement: { default: "start" },
    shadow: { type: [String, Boolean], default: false },
    title: { default: void 0 },
    responsive: {},
    width: { default: void 0 },
    teleportDisabled: { type: Boolean, default: false },
    teleportTo: { default: "body" }
  }, {
    "modelValue": { type: Boolean, ...{
      default: false
    } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["close", "esc", "hidden", "hide", "hide-prevented", "show", "show-prevented", "shown"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BOffcanvas");
    const emit = __emit;
    const slots = useSlots();
    const modelValue = useModel(__props, "modelValue");
    const computedId = useId(() => props.id, "offcanvas");
    const breakpoints = useBreakpoints(breakpointsBootstrapV5);
    const greaterOrEqualToBreakpoint = breakpoints.greaterOrEqual(() => props.responsive ?? "xs");
    const smallerOrEqualToBreakpoint = breakpoints.smallerOrEqual(() => props.responsive ?? "xs");
    const isOpenByBreakpoint = computed(
      () => props.responsive !== void 0 && greaterOrEqualToBreakpoint.value
    );
    useSafeScrollLock(modelValue, () => props.bodyScrolling || isOpenByBreakpoint.value);
    const element = ref(null);
    const fallbackFocusElement = ref(null);
    onKeyStroke(
      "Escape",
      () => {
        hide("esc");
      },
      { target: element }
    );
    const { focused } = useFocus(element, {
      initialValue: modelValue.value && props.noFocus === false
    });
    const isActive = ref(modelValue.value);
    const { needsFallback } = useActivatedFocusTrap({
      element,
      isActive,
      noTrap: () => props.noTrap || isOpenByBreakpoint.value,
      fallbackFocus: {
        classSelector: fallbackClassSelector,
        ref: fallbackFocusElement
      }
    });
    const lazyLoadCompleted = ref(false);
    const wasClosedByBreakpointChange = ref(false);
    const showBackdrop = computed(
      () => (props.responsive === void 0 || !isOpenByBreakpoint.value) && props.hideBackdrop === false && modelValue.value === true
    );
    const lazyShowing = computed(
      () => props.lazy === false || props.lazy === true && lazyLoadCompleted.value === true || props.lazy === true && modelValue.value === true
    );
    const hasHeaderCloseSlot = computed(() => !isEmptySlot(slots["header-close"]));
    const headerCloseClasses = computed(() => [
      { "text-reset": !hasHeaderCloseSlot.value },
      props.headerCloseClass
    ]);
    const headerCloseAttrs = computed(() => ({
      variant: hasHeaderCloseSlot.value ? props.headerCloseVariant : void 0,
      class: headerCloseClasses.value
    }));
    const transitionProps = computed(
      () => wasClosedByBreakpointChange.value === true ? null : {
        enterToClass: "showing",
        enterFromClass: "",
        leaveToClass: "hiding show",
        leaveFromClass: "show"
      }
    );
    const hasFooterSlot = computed(() => !isEmptySlot(slots.footer));
    const computedClasses = computed(() => [
      props.responsive === void 0 ? "offcanvas" : `offcanvas-${props.responsive}`,
      `offcanvas-${props.placement}`,
      {
        show: modelValue.value && isActive.value === true,
        [`shadow-${props.shadow}`]: !!props.shadow
      }
    ]);
    const computedStyles = computed(() => ({
      width: props.width
    }));
    const sharedSlots = computed(() => ({
      visible: modelValue.value,
      placement: props.placement,
      hide
    }));
    const buildTriggerableEvent = (type, opts = {}) => new BvTriggerableEvent(type, {
      cancelable: false,
      target: element.value || null,
      relatedTarget: null,
      trigger: null,
      ...opts,
      componentId: computedId.value
    });
    const hide = (trigger = "") => {
      if (trigger === "backdrop" && props.noCloseOnBackdrop || trigger === "esc" && props.noCloseOnEsc) {
        emit("hide-prevented");
        return;
      }
      const event = buildTriggerableEvent("hide", { cancelable: trigger !== "", trigger });
      if (trigger === "close") {
        emit(trigger, event);
      }
      if (trigger === "esc") {
        emit(trigger, event);
      }
      emit("hide", event);
      if (event.defaultPrevented) {
        emit("hide-prevented");
        return;
      }
      modelValue.value = false;
    };
    const show = () => {
      const event = buildTriggerableEvent("show", { cancelable: true });
      emit("show", event);
      if (event.defaultPrevented) {
        modelValue.value = false;
        emit("show-prevented");
        return;
      }
      modelValue.value = true;
    };
    const focus = () => {
      nextTick(() => {
        if (props.noFocus === false) {
          focused.value = true;
        }
      });
    };
    const OnBeforeEnter = () => show();
    const OnAfterEnter = () => {
      isActive.value = true;
      focus();
      emit("shown", buildTriggerableEvent("shown"));
      if (props.lazy === true) lazyLoadCompleted.value = true;
    };
    const onLeave = () => {
      wasClosedByBreakpointChange.value = false;
      isActive.value = false;
    };
    const OnAfterLeave = () => {
      emit("hidden", buildTriggerableEvent("hidden"));
      if (props.lazy === true) lazyLoadCompleted.value = false;
    };
    useEventListener(element, "bv-toggle", () => {
      modelValue.value ? hide() : show();
    });
    watch(greaterOrEqualToBreakpoint, (newValue) => {
      if (props.responsive === void 0) return;
      modelValue.value = newValue;
    });
    watch(smallerOrEqualToBreakpoint, (newValue) => {
      if (props.responsive === void 0 && newValue === true) return;
      wasClosedByBreakpointChange.value = true;
    });
    __expose({
      hide,
      show
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$1, {
        to: unref(props).teleportTo,
        disabled: unref(props).teleportDisabled || isOpenByBreakpoint.value
      }, {
        default: withCtx(() => [
          createVNode(Transition, mergeProps(transitionProps.value, {
            onBeforeEnter: OnBeforeEnter,
            onAfterEnter: OnAfterEnter,
            onLeave,
            onAfterLeave: OnAfterLeave
          }), {
            default: withCtx(() => [
              withDirectives(createElementVNode("div", mergeProps({
                id: unref(computedId),
                ref_key: "element",
                ref: element,
                "aria-modal": "true",
                role: "dialog",
                class: computedClasses.value,
                style: computedStyles.value,
                tabindex: "-1",
                "aria-labelledby": `${unref(computedId)}-offcanvas-label`,
                "data-bs-backdrop": "false"
              }, _ctx.$attrs), [
                lazyShowing.value ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                  !unref(props).noHeader ? (openBlock(), createElementBlock("div", {
                    key: 0,
                    class: normalizeClass(["offcanvas-header", unref(props).headerClass])
                  }, [
                    renderSlot(_ctx.$slots, "header", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                      createElementVNode("h5", {
                        id: `${unref(computedId)}-offcanvas-label`,
                        class: "offcanvas-title"
                      }, [
                        renderSlot(_ctx.$slots, "title", normalizeProps(guardReactiveProps(sharedSlots.value)), () => [
                          createTextVNode(toDisplayString(unref(props).title), 1)
                        ])
                      ], 8, _hoisted_2),
                      !unref(props).noHeaderClose ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                        hasHeaderCloseSlot.value ? (openBlock(), createBlock(_sfc_main$2, mergeProps({ key: 0 }, headerCloseAttrs.value, {
                          onClick: _cache[0] || (_cache[0] = ($event) => hide("close"))
                        }), {
                          default: withCtx(() => [
                            renderSlot(_ctx.$slots, "header-close")
                          ]),
                          _: 3
                        }, 16)) : (openBlock(), createBlock(_sfc_main$3, mergeProps({
                          key: 1,
                          "aria-label": unref(props).headerCloseLabel
                        }, headerCloseAttrs.value, {
                          onClick: _cache[1] || (_cache[1] = ($event) => hide("close"))
                        }), null, 16, ["aria-label"]))
                      ], 64)) : createCommentVNode("", true)
                    ])
                  ], 2)) : createCommentVNode("", true),
                  createElementVNode("div", mergeProps({
                    class: ["offcanvas-body", unref(props).bodyClass]
                  }, unref(props).bodyAttrs), [
                    renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(sharedSlots.value)))
                  ], 16),
                  hasFooterSlot.value ? (openBlock(), createElementBlock("div", {
                    key: 1,
                    class: normalizeClass(unref(props).footerClass)
                  }, [
                    renderSlot(_ctx.$slots, "footer", normalizeProps(guardReactiveProps(sharedSlots.value)))
                  ], 2)) : createCommentVNode("", true)
                ], 64)) : createCommentVNode("", true),
                unref(needsFallback) ? (openBlock(), createElementBlock("div", {
                  key: 1,
                  ref_key: "fallbackFocusElement",
                  ref: fallbackFocusElement,
                  class: normalizeClass(fallbackClassSelector),
                  tabindex: "0",
                  style: { "width": "0", "height": "0", "overflow": "hidden" }
                }, null, 512)) : createCommentVNode("", true)
              ], 16, _hoisted_1), [
                [vShow, modelValue.value || isOpenByBreakpoint.value]
              ])
            ]),
            _: 3
          }, 16),
          showBackdrop.value ? renderSlot(_ctx.$slots, "backdrop", { key: 0 }, () => [
            createElementVNode("div", {
              class: "offcanvas-backdrop fade show",
              onClick: _cache[2] || (_cache[2] = ($event) => hide("backdrop"))
            })
          ]) : createCommentVNode("", true)
        ]),
        _: 3
      }, 8, ["to", "disabled"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BOffcanvas.vue_vue_type_script_setup_true_lang-CGabsDn7.mjs.map
