import { defineComponent, mergeModels, useModel, computed, watch, openBlock, createElementBlock, normalizeClass, unref, Fragment, renderList, mergeProps, renderSlot, createTextVNode, toDisplayString, createBlock, resolveDynamicComponent, withCtx } from "vue";
import { B as BvEvent } from "./classes-IC0yVJlq.mjs";
import { u as useAlignment } from "./useAlignment-Cw-9AVid.mjs";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { u as useToNumber } from "./index-DlGgXMQF.mjs";
const _hoisted_1 = ["aria-disabled", "aria-label"];
const DEFAULT_PER_PAGE = 20;
const DEFAULT_TOTAL_ROWS = 0;
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BPagination",
  props: /* @__PURE__ */ mergeModels({
    align: { default: "start" },
    ariaControls: { default: void 0 },
    ariaLabel: { default: "Pagination" },
    disabled: { type: Boolean, default: false },
    ellipsisClass: { default: void 0 },
    ellipsisText: { default: "…" },
    firstClass: { default: void 0 },
    firstNumber: { type: Boolean, default: false },
    firstText: { default: "«" },
    hideEllipsis: { type: Boolean, default: false },
    hideGotoEndButtons: { type: Boolean, default: false },
    labelFirstPage: { default: "Go to first page" },
    labelLastPage: { default: "Go to last page" },
    labelNextPage: { default: "Go to next page" },
    labelPage: { default: "Go to page" },
    labelPrevPage: { default: "Go to previous page" },
    lastClass: { default: void 0 },
    lastNumber: { type: Boolean, default: false },
    lastText: { default: "»" },
    limit: { default: 5 },
    nextClass: { default: void 0 },
    nextText: { default: "›" },
    pageClass: { default: void 0 },
    perPage: { default: DEFAULT_PER_PAGE },
    pills: { type: Boolean, default: false },
    prevClass: { default: void 0 },
    prevText: { default: "‹" },
    size: { default: void 0 },
    totalRows: { default: DEFAULT_TOTAL_ROWS }
  }, {
    "modelValue": { default: 1 },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["page-click"], ["update:modelValue"]),
  setup(__props, { emit: __emit }) {
    const ELLIPSIS_THRESHOLD = 3;
    const FIRST_BUTTON = -1;
    const PREV_BUTTON = -2;
    const NEXT_BUTTON = -3;
    const LAST_BUTTON = -4;
    const FIRST_ELLIPSIS = -5;
    const LAST_ELLIPSIS = -6;
    const _props = __props;
    const props = useDefaults(_props, "BPagination");
    const emit = __emit;
    const modelValue = useModel(__props, "modelValue");
    const limitNumber = useToNumber(() => props.limit, { nanToZero: true, method: "parseInt" });
    const perPageNumber = useToNumber(() => props.perPage, { nanToZero: true, method: "parseInt" });
    const totalRowsNumber = useToNumber(() => props.totalRows, { nanToZero: true, method: "parseInt" });
    const modelValueNumber = useToNumber(modelValue, { nanToZero: true, method: "parseInt" });
    const perPageSanitized = computed(() => Math.max(perPageNumber.value || DEFAULT_PER_PAGE, 1));
    const totalRowsSanitized = computed(() => Math.max(totalRowsNumber.value || DEFAULT_TOTAL_ROWS, 0));
    const numberOfPages = computed(() => Math.ceil(totalRowsSanitized.value / perPageSanitized.value));
    const computedFill = computed(() => props.align === "fill");
    const justifyAlign = computed(() => props.align === "fill" ? "start" : props.align);
    const alignment = useAlignment(justifyAlign);
    const isActivePage = (pageNumber) => pageNumber === modelValueNumber.value;
    const getTabIndex = (num) => props.disabled ? null : isActivePage(num) ? "0" : "-1";
    const checkDisabled = (num) => props.disabled || isActivePage(num) || modelValueNumber.value < 1 || // Check if the number is out of bounds
    num < 1 || num > numberOfPages.value;
    const firstDisabled = computed(() => checkDisabled(1));
    const prevDisabled = computed(() => checkDisabled(modelValueNumber.value - 1));
    const lastDisabled = computed(() => checkDisabled(numberOfPages.value));
    const nextDisabled = computed(() => checkDisabled(modelValueNumber.value + 1));
    const getBaseButtonProps = ({
      page,
      classVal,
      dis,
      slotName,
      textValue,
      tabIndex,
      label,
      position,
      isActive,
      role,
      hidden
    }) => ({
      li: {
        "class": [
          "page-item",
          {
            "active": isActive,
            "disabled": dis,
            "flex-fill": computedFill.value,
            "d-flex": computedFill.value && !dis
          },
          classVal
        ],
        role,
        "aria-hidden": hidden
      },
      button: {
        "is": dis ? "span" : "button",
        "class": ["page-link", "text-center", { "flex-grow-1": !dis && computedFill.value }],
        "aria-label": label,
        "aria-controls": props.ariaControls || void 0,
        "aria-disabled": dis ? true : void 0,
        "aria-posinset": position,
        "aria-setsize": position ? numberOfPages.value : void 0,
        "role": "menuitem",
        "type": dis ? void 0 : "button",
        "tabindex": dis ? void 0 : tabIndex
      },
      text: {
        name: slotName,
        active: isActive,
        value: textValue ?? page,
        page,
        disabled: dis,
        index: page - 1,
        content: textValue ? void 0 : page
      },
      clickHandler: (e) => pageClick(e, page)
    });
    const getButtonProps = ({
      page,
      classVal,
      dis,
      slotName,
      textValue,
      label
    }) => getBaseButtonProps({ page, classVal, dis, slotName, textValue, label, tabIndex: "-1" });
    const getPageButtonProps = (page) => getBaseButtonProps({
      page,
      dis: props.disabled,
      classVal: props.pageClass,
      slotName: "page",
      label: props.labelPage ? `${props.labelPage} ${page}` : void 0,
      tabIndex: getTabIndex(page) ?? void 0,
      position: page,
      isActive: isActivePage(page)
    });
    const firstButtonProps = computed(
      () => getButtonProps({
        page: 1,
        dis: firstDisabled.value,
        classVal: props.firstClass,
        slotName: "first-text",
        textValue: props.firstText,
        label: props.labelFirstPage
      })
    );
    const prevButtonProps = computed(
      () => getButtonProps({
        page: Math.max(modelValueNumber.value - 1, 1),
        dis: prevDisabled.value,
        classVal: props.prevClass,
        slotName: "prev-text",
        textValue: props.prevText,
        label: props.labelPrevPage
      })
    );
    const nextButtonProps = computed(
      () => getButtonProps({
        page: Math.min(modelValueNumber.value + 1, numberOfPages.value),
        dis: nextDisabled.value,
        classVal: props.nextClass,
        slotName: "next-text",
        textValue: props.nextText,
        label: props.labelNextPage
      })
    );
    const lastButtonProps = computed(
      () => getButtonProps({
        page: numberOfPages.value,
        dis: lastDisabled.value,
        classVal: props.lastClass,
        slotName: "last-text",
        textValue: props.lastText,
        label: props.labelLastPage
      })
    );
    const ellipsisProps = computed(() => ({
      li: {
        class: [
          "page-item",
          "disabled",
          "text-center",
          "bv-d-xs-down-none",
          computedFill.value ? "flex-fill" : "",
          props.ellipsisClass
        ],
        role: "separator"
      },
      span: {
        class: ["page-link"]
      }
    }));
    const computedWrapperClasses = computed(() => [
      alignment.value,
      {
        [`pagination-${props.size}`]: props.size !== void 0,
        "b-pagination-pills": props.pills
      }
    ]);
    const pagination = computed(() => ({
      pageSize: perPageSanitized.value,
      totalRows: totalRowsNumber.value,
      numberOfPages: numberOfPages.value
    }));
    const pageClick = (event, pageNumber) => {
      if (pageNumber === modelValueNumber.value) return;
      const clickEvent = new BvEvent("page-click", {
        cancelable: true,
        target: event.target
      });
      emit("page-click", clickEvent, pageNumber);
      if (clickEvent.defaultPrevented) return;
      modelValue.value = pageNumber;
    };
    watch(modelValueNumber, (newValue) => {
      const sanitizeCurrentPage = (value, numberOfPages2) => {
        const page = value || 1;
        return page > numberOfPages2 ? numberOfPages2 : page < 1 ? 1 : page;
      };
      const calculatedValue = sanitizeCurrentPage(newValue, numberOfPages.value);
      if (calculatedValue === modelValue.value) return;
      modelValue.value = calculatedValue;
    });
    watch(pagination, (oldValue, newValue) => {
      if (newValue.pageSize !== oldValue.pageSize && newValue.totalRows === oldValue.totalRows) {
        modelValue.value = 1;
      } else if (newValue.numberOfPages !== oldValue.numberOfPages && modelValueNumber.value > newValue.numberOfPages) {
        modelValue.value = 1;
      }
    });
    const pages = computed(
      () => elements.value.map((p) => {
        switch (p) {
          case FIRST_BUTTON:
            return { id: p, ...firstButtonProps.value };
          case PREV_BUTTON:
            return { id: p, ...prevButtonProps.value };
          case NEXT_BUTTON:
            return { id: p, ...nextButtonProps.value };
          case LAST_BUTTON:
            return { id: p, ...lastButtonProps.value };
          case FIRST_ELLIPSIS:
          case LAST_ELLIPSIS:
            return { id: p, ...ellipsisProps.value };
          default:
            return { id: p, ...getPageButtonProps(p) };
        }
      })
    );
    const elements = computed(() => {
      const pages2 = numberOfPages.value;
      const { value } = modelValueNumber;
      const limit = limitNumber.value;
      const firstPage = props.firstNumber ? 1 : 0;
      const lastPage = props.lastNumber ? 1 : 0;
      const hideEllipsis = props.hideEllipsis || limit <= ELLIPSIS_THRESHOLD;
      const hideFirstButton = props.hideGotoEndButtons && !props.firstNumber ? 1 : 0;
      const hideLastButton = props.hideGotoEndButtons && !props.lastNumber ? 1 : 0;
      const showFirstButton = hideFirstButton ? 0 : 1;
      const showLastButton = hideLastButton ? 0 : 1;
      if (pages2 < limit + firstPage + lastPage) {
        return [
          !firstPage && !hideFirstButton ? FIRST_BUTTON : null,
          PREV_BUTTON,
          ...Array.from({ length: pages2 }, (_, index) => index + 1),
          NEXT_BUTTON,
          !lastPage && !hideLastButton ? LAST_BUTTON : null
        ].filter((x) => x !== null);
      }
      const buttons = Array.from({ length: limit + 4 - (hideFirstButton + hideLastButton) });
      if (!hideFirstButton) {
        if (!firstPage) {
          buttons[0] = FIRST_BUTTON;
          buttons[1] = PREV_BUTTON;
        } else {
          buttons[0] = PREV_BUTTON;
          buttons[1] = 1;
        }
      } else {
        buttons[0] = PREV_BUTTON;
      }
      if (!hideLastButton) {
        if (!lastPage) {
          buttons[buttons.length - 1] = LAST_BUTTON;
          buttons[buttons.length - 2] = NEXT_BUTTON;
        } else {
          buttons[buttons.length - 1] = NEXT_BUTTON;
          buttons[buttons.length - 2] = pages2;
        }
      } else {
        buttons[buttons.length - 1] = NEXT_BUTTON;
      }
      const halfLimit = Math.floor(limit / 2);
      if (value <= halfLimit + firstPage) {
        for (let index = 1; index <= limit; index++) {
          buttons[index + 1 - hideFirstButton] = index + firstPage;
        }
        if (!hideEllipsis) {
          buttons[buttons.length - (2 + showLastButton)] = LAST_ELLIPSIS;
        }
      }
      if (value > pages2 - halfLimit - lastPage) {
        const start = pages2 - (limit - 1) - lastPage;
        for (let index = 0; index < limit; index++) {
          buttons[index + 2 - hideFirstButton] = start + index;
        }
        if (!hideEllipsis) {
          buttons[1 + showFirstButton] = FIRST_ELLIPSIS;
        }
      }
      if (!buttons[2]) {
        const start = value - Math.floor(limit / 2);
        for (let index = 0; index < limit; index++) {
          buttons[index + 2 - hideFirstButton] = start + index;
        }
        if (!hideEllipsis) {
          buttons[1 + showFirstButton] = FIRST_ELLIPSIS;
          buttons[buttons.length - (2 + showLastButton)] = LAST_ELLIPSIS;
        }
      }
      return buttons.filter((x) => x !== null);
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("ul", {
        class: normalizeClass(["pagination", computedWrapperClasses.value]),
        role: "menubar",
        "aria-disabled": unref(props).disabled,
        "aria-label": unref(props).ariaLabel || void 0
      }, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(pages.value, (page) => {
          return openBlock(), createElementBlock("li", mergeProps({
            key: `page-${page.id}`,
            ref_for: true
          }, page.li), [
            page.id === FIRST_ELLIPSIS || page.id === LAST_ELLIPSIS ? (openBlock(), createElementBlock("span", mergeProps({
              key: 0,
              ref_for: true
            }, ellipsisProps.value.span), [
              renderSlot(_ctx.$slots, "ellipsis-text", {}, () => [
                createTextVNode(toDisplayString(unref(props).ellipsisText || "..."), 1)
              ])
            ], 16)) : (openBlock(), createBlock(resolveDynamicComponent(page.button.is), mergeProps({
              key: 1,
              ref_for: true
            }, page.button, {
              onClick: page.clickHandler
            }), {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, page.text.name, {
                  disabled: page.text.disabled,
                  page: page.text.page,
                  index: page.text.index,
                  active: page.text.active,
                  content: page.text.value
                }, () => [
                  createTextVNode(toDisplayString(page.text.value), 1)
                ])
              ]),
              _: 2
            }, 1040, ["onClick"]))
          ], 16);
        }), 128))
      ], 10, _hoisted_1);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BPagination.vue_vue_type_script_setup_true_lang-Dprt0p13.mjs.map
