import { defineComponent, inject, computed, openBlock, createElementBlock, normalizeClass, unref, normalizeStyle, renderSlot, createTextVNode, toDisplayString, provide, toRef, createVNode } from "vue";
import { u as useColorVariantClasses } from "./useColorVariantClasses-ZDE19TZw.mjs";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { q as progressInjectionKey } from "./keys-DuZp76_V.mjs";
import { u as useToNumber } from "./index-DlGgXMQF.mjs";
const _hoisted_1 = ["aria-valuenow", "aria-valuemax"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BProgressBar",
  props: {
    animated: { type: Boolean, default: false },
    label: { default: void 0 },
    labelHtml: { default: void 0 },
    max: { default: void 0 },
    precision: { default: 0 },
    showProgress: { type: Boolean, default: false },
    showValue: { type: Boolean, default: false },
    striped: { type: Boolean, default: false },
    value: { default: 0 },
    variant: { default: null },
    bgVariant: { default: null },
    textVariant: { default: null }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BProgressBar");
    const parentData = inject(progressInjectionKey, null);
    const colorClasses = useColorVariantClasses(props);
    const computedClasses = computed(() => [
      colorClasses.value,
      {
        "progress-bar-animated": props.animated || (parentData == null ? void 0 : parentData.animated.value),
        "progress-bar-striped": props.striped || (parentData == null ? void 0 : parentData.striped.value) || props.animated || (parentData == null ? void 0 : parentData.animated.value)
      }
    ]);
    const numberPrecision = useToNumber(() => props.precision);
    const numberValue = useToNumber(() => props.value);
    const numberMax = useToNumber(() => props.max ?? NaN);
    const parentMaxNumber = useToNumber(() => (parentData == null ? void 0 : parentData.max.value) ?? NaN);
    const computedLabel = computed(
      () => props.labelHtml !== void 0 ? props.labelHtml : props.showValue || (parentData == null ? void 0 : parentData.showValue.value) ? numberValue.value.toFixed(numberPrecision.value) : props.showProgress || (parentData == null ? void 0 : parentData.showProgress.value) ? (numberValue.value * 100 / (numberMax.value || 100)).toFixed(numberPrecision.value) : props.label !== void 0 ? props.label : ""
    );
    const computedWidth = computed(
      () => parentMaxNumber.value ? `${numberValue.value * 100 / parentMaxNumber.value}%` : numberMax.value ? `${numberValue.value * 100 / numberMax.value}%` : typeof props.value === "string" ? props.value : `${props.value}%`
    );
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["progress-bar", computedClasses.value]),
        role: "progressbar",
        "aria-valuenow": unref(props).value,
        "aria-valuemin": "0",
        "aria-valuemax": unref(props).max,
        style: normalizeStyle({ width: computedWidth.value })
      }, [
        renderSlot(_ctx.$slots, "default", {}, () => [
          createTextVNode(toDisplayString(computedLabel.value), 1)
        ])
      ], 14, _hoisted_1);
    };
  }
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BProgress",
  props: {
    height: { default: void 0 },
    animated: { type: Boolean, default: void 0 },
    max: { default: 100 },
    precision: { default: void 0 },
    showProgress: { type: Boolean, default: void 0 },
    showValue: { type: Boolean, default: void 0 },
    striped: { type: Boolean, default: void 0 },
    value: { default: void 0 },
    variant: { default: void 0 },
    bgVariant: { default: void 0 },
    textVariant: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BProgress");
    provide(progressInjectionKey, {
      animated: toRef(() => props.animated),
      max: toRef(() => props.max),
      showProgress: toRef(() => props.showProgress),
      showValue: toRef(() => props.showValue),
      striped: toRef(() => props.striped)
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: "progress",
        style: normalizeStyle({ height: unref(props).height })
      }, [
        renderSlot(_ctx.$slots, "default", {}, () => [
          createVNode(_sfc_main$1, {
            animated: unref(props).animated,
            max: unref(props).max,
            precision: unref(props).precision,
            "show-progress": unref(props).showProgress,
            "show-value": unref(props).showValue,
            striped: unref(props).striped,
            value: unref(props).value,
            variant: unref(props).variant,
            "text-variant": unref(props).textVariant,
            "bg-variant": unref(props).bgVariant
          }, null, 8, ["animated", "max", "precision", "show-progress", "show-value", "striped", "value", "variant", "text-variant", "bg-variant"])
        ])
      ], 4);
    };
  }
});
export {
  _sfc_main as _,
  _sfc_main$1 as a
};
//# sourceMappingURL=BProgress.vue_vue_type_script_setup_true_lang-C-D_koFH.mjs.map
