import { defineComponent, mergeModels, ref, useModel, computed, watchEffect, watch, openBlock, createBlock, mergeProps, unref, withCtx, createElementBlock, normalizeClass, resolveDynamicComponent, renderSlot, createElementVNode, toDisplayString, createCommentVNode, createTextVNode, Fragment, renderList, createVNode, TransitionGroup } from "vue";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { u as useBLinkHelper } from "./useBLinkHelper-Bvtov_sk.mjs";
import { _ as _sfc_main$3 } from "./BTransition.vue_vue_type_style_index_0_lang-X5a8jq3A.mjs";
import { _ as _sfc_main$4 } from "./BCloseButton.vue_vue_type_script_setup_true_lang-B_GsCJs6.mjs";
import { _ as _sfc_main$2 } from "./BLink.vue_vue_type_script_setup_true_lang-DS4JR4ch.mjs";
import { _ as _sfc_main$5 } from "./BProgress.vue_vue_type_script_setup_true_lang-C-D_koFH.mjs";
import { a as BvTriggerableEvent } from "./classes-IC0yVJlq.mjs";
import { u as useCountdown, a as useCountdownHover } from "./useCountdownHover-Ds0unFZR.mjs";
import { u as useColorVariantClasses } from "./useColorVariantClasses-ZDE19TZw.mjs";
import { _ as _sfc_main$6 } from "./ConditionalTeleport.vue_vue_type_script_lang-CBHk9gJ3.mjs";
import { useToast } from "./src/composables/useToast/index.mjs";
const _hoisted_1 = ["id", "role", "aria-live", "aria-atomic"];
const _hoisted_2 = { class: "me-auto" };
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BToast",
  props: /* @__PURE__ */ mergeModels({
    body: { default: void 0 },
    bodyClass: { default: void 0 },
    headerClass: { default: void 0 },
    headerTag: { default: "div" },
    id: { default: void 0 },
    interval: { default: "requestAnimationFrame" },
    isStatus: { type: Boolean, default: false },
    noCloseButton: { type: Boolean, default: false },
    noFade: { type: Boolean, default: false },
    noHoverPause: { type: Boolean, default: false },
    noResumeOnHoverLeave: { type: Boolean, default: false },
    progressProps: { default: void 0 },
    showOnPause: { type: Boolean, default: true },
    solid: { type: Boolean, default: false },
    title: { default: void 0 },
    toastClass: { default: void 0 },
    transProps: { default: void 0 },
    variant: { default: void 0 },
    bgVariant: { default: null },
    textVariant: { default: null },
    active: { type: Boolean, default: void 0 },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: void 0 },
    href: { default: void 0 },
    icon: { type: Boolean, default: void 0 },
    noRel: { type: Boolean, default: void 0 },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: void 0 }
  }, {
    "modelValue": { type: [Boolean, Number], ...{ default: false } },
    "modelModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["close", "close-countdown", "hide", "hidden", "show", "shown", "show-prevented", "hide-prevented"], ["update:modelValue"]),
  setup(__props, { expose: __expose, emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BToast");
    const emit = __emit;
    const element = ref(null);
    const modelValue = useModel(__props, "modelValue");
    const { computedLink, computedLinkProps } = useBLinkHelper(props);
    const countdownLength = computed(
      () => typeof modelValue.value === "boolean" ? 0 : modelValue.value
    );
    const {
      isActive,
      pause,
      restart,
      resume,
      stop,
      isPaused,
      value: remainingMs
    } = useCountdown(countdownLength, props.interval, {
      immediate: typeof modelValue.value === "number"
    });
    useCountdownHover(
      element,
      computed(() => ({
        noHoverPause: props.noHoverPause,
        noResumeOnHoverLeave: props.noResumeOnHoverLeave
      })),
      { pause, resume }
    );
    watchEffect(() => {
      emit("close-countdown", remainingMs.value);
    });
    const computedTag = computed(() => computedLink.value ? _sfc_main$2 : "div");
    const isToastVisible = computed(
      () => typeof modelValue.value === "boolean" ? modelValue.value : isActive.value || props.showOnPause && isPaused.value
    );
    const colorClasses = useColorVariantClasses(props);
    const computedClasses = computed(() => [
      colorClasses.value,
      {
        show: isToastVisible.value
      }
    ]);
    const buildTriggerableEvent = (type, opts = {}) => new BvTriggerableEvent(type, {
      cancelable: false,
      target: element.value || null,
      relatedTarget: null,
      trigger: null,
      ...opts,
      componentId: props.id
    });
    const showFn = () => {
      const event = buildTriggerableEvent("show", { cancelable: true });
      emit("show", event);
      if (event.defaultPrevented) {
        if (modelValue.value) modelValue.value = false;
        emit("show-prevented");
        return;
      }
      if (!modelValue.value) modelValue.value = true;
    };
    const hideFn = (trigger = "") => {
      const event = buildTriggerableEvent("hide", { cancelable: trigger !== "", trigger });
      emit("hide", event);
      if (trigger === "close") {
        emit("close", event);
      }
      if (event.defaultPrevented) {
        emit("hide-prevented");
        if (!modelValue.value) modelValue.value = true;
        return;
      }
      if (typeof modelValue.value === "boolean") {
        modelValue.value = false;
      } else {
        modelValue.value = 0;
        stop();
      }
    };
    const onBeforeEnter = () => {
      showFn();
    };
    const onAfterEnter = () => {
      emit("shown", buildTriggerableEvent("shown"));
    };
    const onAfterLeave = () => {
      emit("hidden", buildTriggerableEvent("hidden"));
    };
    watch(isActive, (newValue) => {
      if (newValue === false && isPaused.value === false && !!modelValue.value) {
        hideFn();
      }
    });
    __expose({
      pause,
      restart,
      resume,
      stop
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$3, mergeProps({
        "no-fade": unref(props).noFade
      }, unref(props).transProps, {
        onBeforeEnter,
        onAfterEnter,
        onAfterLeave
      }), {
        default: withCtx(() => [
          isToastVisible.value ? (openBlock(), createElementBlock("div", {
            key: 0,
            id: unref(props).id,
            ref_key: "element",
            ref: element,
            class: normalizeClass(["toast", [unref(props).toastClass, computedClasses.value]]),
            tabindex: "0",
            role: !isToastVisible.value ? void 0 : unref(props).isStatus ? "status" : "alert",
            "aria-live": !isToastVisible.value ? void 0 : unref(props).isStatus ? "polite" : "assertive",
            "aria-atomic": !isToastVisible.value ? void 0 : true
          }, [
            _ctx.$slots.title || unref(props).title ? (openBlock(), createBlock(resolveDynamicComponent(unref(props).headerTag), {
              key: 0,
              class: normalizeClass(["toast-header", unref(props).headerClass])
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "title", { hide: hideFn }, () => [
                  createElementVNode("strong", _hoisted_2, toDisplayString(unref(props).title), 1)
                ]),
                !unref(props).noCloseButton ? (openBlock(), createBlock(_sfc_main$4, {
                  key: 0,
                  onClick: _cache[0] || (_cache[0] = ($event) => hideFn("close"))
                })) : createCommentVNode("", true)
              ]),
              _: 3
            }, 8, ["class"])) : createCommentVNode("", true),
            _ctx.$slots.default || unref(props).body ? (openBlock(), createBlock(resolveDynamicComponent(computedTag.value), mergeProps({
              key: 1,
              class: ["toast-body", unref(props).bodyClass],
              style: { "display": "block" }
            }, unref(computedLinkProps), {
              onClick: _cache[1] || (_cache[1] = ($event) => unref(computedLink) ? hideFn() : () => {
              })
            }), {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "default", { hide: hideFn }, () => [
                  createTextVNode(toDisplayString(unref(props).body), 1)
                ])
              ]),
              _: 3
            }, 16, ["class"])) : createCommentVNode("", true),
            typeof modelValue.value === "number" && unref(props).progressProps !== void 0 ? (openBlock(), createBlock(_sfc_main$5, {
              key: 2,
              animated: unref(props).progressProps.animated,
              precision: unref(props).progressProps.precision,
              "show-progress": unref(props).progressProps.showProgress,
              "show-value": unref(props).progressProps.showValue,
              striped: unref(props).progressProps.striped,
              variant: unref(props).progressProps.variant,
              max: modelValue.value,
              value: unref(remainingMs),
              height: "4px"
            }, null, 8, ["animated", "precision", "show-progress", "show-value", "striped", "variant", "max", "value"])) : createCommentVNode("", true)
          ], 10, _hoisted_1)) : createCommentVNode("", true)
        ]),
        _: 3
      }, 16, ["no-fade"]);
    };
  }
});
const positionClasses = {
  "top-start": "top-0 start-0",
  "top-center": "top-0 start-50 translate-middle-x",
  "top-end": "top-0 end-0",
  "middle-start": "top-50 start-0 translate-middle-y",
  "middle-center": "top-50 start-50 translate-middle",
  "middle-end": "top-50 end-0 translate-middle-y",
  "bottom-start": "bottom-0 start-0",
  "bottom-center": "bottom-0 start-50 translate-middle-x",
  "bottom-end": "bottom-0 end-0"
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    inheritAttrs: false
  },
  __name: "BToastOrchestrator",
  props: {
    appendToast: { type: Boolean, default: false },
    teleportDisabled: { type: Boolean, default: false },
    teleportTo: { default: "body" }
  },
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BToastOrchestrator");
    const tools = useToast();
    watch(
      () => props.appendToast,
      (value) => {
        var _a;
        (_a = tools._setIsAppend) == null ? void 0 : _a.call(tools, value);
      },
      { immediate: true }
    );
    __expose({
      ...tools
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$6, {
        to: unref(props).teleportTo,
        disabled: unref(props).teleportDisabled
      }, {
        default: withCtx(() => [
          createElementVNode("div", mergeProps({ id: "__BVID__toaster-container" }, _ctx.$attrs), [
            (openBlock(true), createElementBlock(Fragment, null, renderList(unref(positionClasses), (value, key) => {
              return openBlock(), createElementBlock("div", {
                key,
                class: normalizeClass([value, "toast-container position-fixed p-3"])
              }, [
                createVNode(TransitionGroup, { name: "b-list" }, {
                  default: withCtx(() => {
                    var _a;
                    return [
                      (openBlock(true), createElementBlock(Fragment, null, renderList((_a = unref(tools).toasts) == null ? void 0 : _a.value.filter((el) => el.props.pos === key), (toast) => {
                        return openBlock(), createBlock(resolveDynamicComponent(toast.component ?? _sfc_main$1), mergeProps({
                          key: toast.props._self,
                          ref_for: true
                        }, toast.props, {
                          "model-value": toast.props._modelValue,
                          "trans-props": { ...toast.props.transProps, appear: true },
                          "onUpdate:modelValue": ($event) => {
                            var _a2, _b;
                            return (_b = (_a2 = unref(tools)).leave) == null ? void 0 : _b.call(_a2, toast.props._self);
                          },
                          onHide: ($event) => {
                            var _a2, _b;
                            return (_b = (_a2 = unref(tools)).remove) == null ? void 0 : _b.call(_a2, toast.props._self);
                          }
                        }), null, 16, ["model-value", "trans-props", "onUpdate:modelValue", "onHide"]);
                      }), 128))
                    ];
                  }),
                  _: 2
                }, 1024)
              ], 2);
            }), 128))
          ], 16)
        ]),
        _: 1
      }, 8, ["to", "disabled"]);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BToastOrchestrator.vue_vue_type_style_index_0_lang-CFmlSsxb.mjs.map
