import { defineComponent, mergeModels, useModel, computed, ref, openBlock, createBlock, mergeProps, createSlots, renderList, withCtx, renderSlot, normalizeProps, guardReactiveProps, createElementBlock, Fragment, unref, resolveDynamicComponent } from "vue";
import { useTooltip } from "./src/composables/useTooltip/index.mjs";
import { _ as _sfc_main$2 } from "./floatingUi-DkjyEWfi.mjs";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BTooltip",
  props: /* @__PURE__ */ mergeModels({
    interactive: { type: Boolean, default: void 0 },
    boundary: {},
    boundaryPadding: {},
    click: { type: Boolean, default: void 0 },
    closeOnHide: { type: Boolean },
    content: { default: void 0 },
    customClass: { default: void 0 },
    delay: { default: void 0 },
    floatingMiddleware: { default: void 0 },
    html: { type: Boolean, default: void 0 },
    id: { default: void 0 },
    inline: { type: Boolean, default: void 0 },
    manual: { type: Boolean, default: void 0 },
    noAutoClose: { type: Boolean, default: void 0 },
    noFade: { type: Boolean, default: void 0 },
    noFlip: { type: Boolean, default: void 0 },
    noHide: { type: Boolean, default: void 0 },
    noShift: { type: Boolean, default: void 0 },
    noSize: { type: Boolean },
    noninteractive: { type: Boolean, default: void 0 },
    offset: { default: void 0 },
    placement: { default: void 0 },
    persistent: { type: Boolean },
    realtime: { type: Boolean, default: void 0 },
    reference: { default: void 0 },
    strategy: { default: void 0 },
    target: { default: void 0 },
    title: { default: void 0 },
    variant: { default: void 0 },
    teleportDisabled: { type: Boolean, default: void 0 },
    teleportTo: { default: void 0 }
  }, {
    "modelValue": { type: Boolean, ...{ default: void 0 } },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    var _a, _b, _c;
    const _props = __props;
    const props = useDefaults(_props, "BTooltip");
    const modelValue = useModel(__props, "modelValue");
    const computedProps = computed(() => {
      const { interactive, noninteractive, ...rest } = props;
      return { noninteractive: noninteractive !== void 0 ? noninteractive : !interactive, ...rest };
    });
    const popover = ref(null);
    __expose({
      hide: (_a = popover.value) == null ? void 0 : _a.hide,
      show: (_b = popover.value) == null ? void 0 : _b.show,
      toggle: (_c = popover.value) == null ? void 0 : _c.toggle
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$2, mergeProps({
        ref_key: "popover",
        ref: popover
      }, computedProps.value, {
        modelValue: modelValue.value,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => modelValue.value = $event),
        tooltip: ""
      }), createSlots({ _: 2 }, [
        renderList(_ctx.$slots, (_, name) => {
          return {
            name,
            fn: withCtx((slotData) => [
              renderSlot(_ctx.$slots, name, normalizeProps(guardReactiveProps(slotData)))
            ])
          };
        })
      ]), 1040, ["modelValue"]);
    };
  }
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BTooltipOrchestrator",
  setup(__props, { expose: __expose }) {
    const tools = useTooltip();
    __expose({
      ...tools
    });
    return (_ctx, _cache) => {
      var _a;
      return openBlock(true), createElementBlock(Fragment, null, renderList((_a = unref(tools).tooltips) == null ? void 0 : _a.value, ([self, tooltip]) => {
        return openBlock(), createBlock(resolveDynamicComponent(tooltip.component ?? _sfc_main$1), mergeProps({
          key: self,
          ref_for: true
        }, tooltip.props, {
          "model-value": tooltip.props._modelValue,
          reference: tooltip.props._reference,
          "onUpdate:modelValue": ($event) => {
            var _a2, _b;
            return (_b = (_a2 = unref(tools)).set) == null ? void 0 : _b.call(_a2, self, { ...tooltip.props, _modelValue: $event });
          }
        }), null, 16, ["model-value", "reference", "onUpdate:modelValue"]);
      }), 128);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BTooltipOrchestrator.vue_vue_type_script_setup_true_lang-ByHTqqBN.mjs.map
