import { defineComponent, computed, openBlock, createBlock, Transition, mergeProps, withCtx, renderSlot } from "vue";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BTransition",
  props: {
    appear: { type: Boolean, default: false },
    mode: { default: void 0 },
    noFade: { type: Boolean, default: false },
    transProps: { default: void 0 }
  },
  emits: ["after-appear", "after-enter", "after-leave", "appear", "before-appear", "before-enter", "before-leave", "enter", "appear-cancelled", "enter-cancelled", "leave", "leave-cancelled"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const fadeProperties = computed(() => {
      const NO_FADE_PROPS = {
        name: "",
        enterActiveClass: "",
        enterToClass: "",
        leaveActiveClass: "",
        leaveToClass: "showing",
        enterFromClass: "showing",
        leaveFromClass: ""
      };
      const FADE_PROPS = {
        ...NO_FADE_PROPS,
        enterActiveClass: "fade showing",
        leaveActiveClass: "fade showing"
      };
      return props.noFade ? NO_FADE_PROPS : FADE_PROPS;
    });
    const baseProperties = computed(() => ({ mode: props.mode, css: true, ...fadeProperties.value }));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(Transition, mergeProps({ ...baseProperties.value, ...props.transProps }, {
        appear: props.appear,
        onAfterAppear: _cache[0] || (_cache[0] = ($event) => emit("after-appear", $event)),
        onAfterEnter: _cache[1] || (_cache[1] = ($event) => emit("after-enter", $event)),
        onAfterLeave: _cache[2] || (_cache[2] = ($event) => emit("after-leave", $event)),
        onAppear: _cache[3] || (_cache[3] = ($event) => emit("appear", $event)),
        onBeforeAppear: _cache[4] || (_cache[4] = ($event) => emit("before-appear", $event)),
        onBeforeEnter: _cache[5] || (_cache[5] = ($event) => emit("before-enter", $event)),
        onBeforeLeave: _cache[6] || (_cache[6] = ($event) => emit("before-leave", $event)),
        onEnter: _cache[7] || (_cache[7] = ($event) => emit("enter", $event)),
        onAppearCancelled: _cache[8] || (_cache[8] = ($event) => emit("appear-cancelled", $event)),
        onEnterCancelled: _cache[9] || (_cache[9] = ($event) => emit("enter-cancelled", $event)),
        onLeave: _cache[10] || (_cache[10] = ($event) => emit("leave", $event)),
        onLeaveCancelled: _cache[11] || (_cache[11] = ($event) => emit("leave-cancelled", $event))
      }), {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 16, ["appear"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BTransition.vue_vue_type_style_index_0_lang-X5a8jq3A.mjs.map
