const attemptFocus = (el, options = {}) => {
  const getActiveElement = (excludes = []) => {
    const { activeElement } = document;
    return activeElement && !excludes.some((el2) => el2 === activeElement) ? activeElement : null;
  };
  const isActiveElement = (el2) => el2 === getActiveElement();
  try {
    el.focus(options);
  } catch (e) {
    console.error(e);
  }
  return isActiveElement(el);
};
const isEmptySlot = (el) => ((el == null ? void 0 : el()) ?? []).length === 0;
const isVisible = (el) => {
  if (el.getAttribute("display") === "none") {
    return false;
  }
  const bcr = el.getBoundingClientRect();
  return !!(bcr && bcr.height > 0 && bcr.width > 0);
};
const getTransitionDelay = (element) => {
  const style = window.getComputedStyle(element);
  const transitionDelay = style.transitionDelay.split(",")[0] || "";
  const transitionDuration = style.transitionDuration.split(",")[0] || "";
  const transitionDelayMs = Number(transitionDelay.slice(0, -1)) * 1e3;
  const transitionDurationMs = Number(transitionDuration.slice(0, -1)) * 1e3;
  return transitionDelayMs + transitionDurationMs;
};
export {
  isVisible as a,
  attemptFocus as b,
  getTransitionDelay as g,
  isEmptySlot as i
};
//# sourceMappingURL=dom-B-SQyhbA.mjs.map
