const bvnPrefix = (value, suffix = "") => {
  const suffixWithTrail = `${suffix}___`;
  return `___BVN__ID__${value}__${suffix ? suffixWithTrail : ""}`;
};
const createBvnInjectionKey = (name) => bvnPrefix(name);
const carouselInjectionKey = createBvnInjectionKey("carousel");
const tabsInjectionKey = createBvnInjectionKey("tabs");
const progressInjectionKey = createBvnInjectionKey("progress");
const listGroupInjectionKey = createBvnInjectionKey("listGroup");
const avatarGroupInjectionKey = createBvnInjectionKey("avatarGroup");
const accordionInjectionKey = createBvnInjectionKey("accordion");
const checkboxGroupKey = createBvnInjectionKey("checkboxGroup");
const radioGroupKey = createBvnInjectionKey("radioGroup");
const collapseInjectionKey = createBvnInjectionKey("collapse");
const dropdownInjectionKey = createBvnInjectionKey("dropdown");
const navbarInjectionKey = createBvnInjectionKey("navbar");
const rtlPluginKey = createBvnInjectionKey("rtlPlugin");
const breadcrumbPluginKey = createBvnInjectionKey("breadcrumbPlugin");
const modalManagerPluginKey = createBvnInjectionKey("modalManagerPlugin");
const defaultsKey = createBvnInjectionKey("defaults");
const inputGroupKey = createBvnInjectionKey("inputGroup");
const toastPluginKey = createBvnInjectionKey("toastPlugin");
const modalControllerPluginKey = createBvnInjectionKey("modalControllerPlugin");
const tooltipPluginKey = createBvnInjectionKey("tooltipPlugin");
const popoverPluginKey = createBvnInjectionKey("popoverPlugin");
export {
  tooltipPluginKey as a,
  breadcrumbPluginKey as b,
  collapseInjectionKey as c,
  defaultsKey as d,
  dropdownInjectionKey as e,
  modalManagerPluginKey as f,
  bvnPrefix as g,
  accordionInjectionKey as h,
  inputGroupKey as i,
  avatarGroupInjectionKey as j,
  checkboxGroupKey as k,
  radioGroupKey as l,
  modalControllerPluginKey as m,
  navbarInjectionKey as n,
  listGroupInjectionKey as o,
  popoverPluginKey as p,
  progressInjectionKey as q,
  rtlPluginKey as r,
  tabsInjectionKey as s,
  toastPluginKey as t,
  carouselInjectionKey as u
};
//# sourceMappingURL=keys-DuZp76_V.mjs.map
