const omit = (objToPluck, keysToPluck) => Object.keys(objToPluck).filter((key) => !keysToPluck.map((el) => el.toString()).includes(key)).reduce((result, key) => ({ ...result, [key]: objToPluck[key] }), {});
const pick = (objToPluck, keysToPluck) => [...keysToPluck].reduce(
  (memo, prop) => {
    memo[prop] = objToPluck[prop];
    return memo;
  },
  {}
);
const get = (value, path, defaultValue) => {
  const segments = path.split(/[.[\]]/g);
  let current = value;
  for (const key of segments) {
    if (current === null) return defaultValue;
    if (current === void 0) return defaultValue;
    if (key.trim() === "") continue;
    current = current[key];
  }
  if (current === void 0) return defaultValue;
  return current;
};
const set = (initial, path, value) => {
  const clone = (obj) => {
    const isPrimitive = (value2) => value2 === void 0 || value2 === null || typeof value2 !== "object" && typeof value2 !== "function";
    if (isPrimitive(obj)) {
      return obj;
    }
    if (typeof obj === "function") {
      return obj.bind({});
    }
    const newObj = new obj.constructor();
    Object.getOwnPropertyNames(obj).forEach((prop) => {
      newObj[prop] = obj[prop];
    });
    return newObj;
  };
  const toInt = (value2, defaultValue) => {
    const def = defaultValue === void 0 ? 0 : defaultValue;
    if (value2 === null || value2 === void 0) {
      return def;
    }
    const result = Number.parseInt(value2);
    return Number.isNaN(result) ? def : result;
  };
  if (!initial) return {};
  if (!path || value === void 0) return initial;
  const segments = path.split(/[.[\]]/g).filter((x) => !!x.trim());
  const _set = (node) => {
    if (segments.length > 1) {
      const key = segments.shift();
      const nextIsNum = toInt(segments[0], null) === null ? false : true;
      node[key] = node[key] === void 0 ? nextIsNum ? [] : {} : node[key];
      _set(node[key]);
    } else {
      node[segments[0]] = value;
    }
  };
  const cloned = clone(initial);
  _set(cloned);
  return cloned;
};
export {
  get as g,
  omit as o,
  pick as p,
  set as s
};
//# sourceMappingURL=object-DIbMZaP9.mjs.map
