import { MaybeRefOrGetter, Ref } from 'vue';
import { UseFocusTrapOptions } from '@vueuse/integrations/useFocusTrap';
export declare const useActivatedFocusTrap: ({ element, isActive, noTrap, fallbackFocus, }: {
    element: Ref<HTMLElement | null>;
    isActive: MaybeRefOrGetter<boolean>;
    noTrap: MaybeRefOrGetter<boolean>;
    /**
     * We need this in the case when there are no focusable elements in the trap. So elements that use this need to implement a fallback focus element.
     *
     * Use the `needsFallback` ref to check if you can v-if the element or not. So it's not included in the component tree when not needed.
     */
    fallbackFocus: {
        ref: Ref<HTMLElement | null>;
        /**
         * The fallback focus element needs some specific selector to ensure it's not included when checking for focusable elements
         */
        classSelector: string;
    };
}, focusTrapOpts?: UseFocusTrapOptions) => {
    needsFallback: Readonly<Ref<boolean, boolean>>;
};
