import { getCurrentInstance, computed, toValue } from "vue";
import { u as useSharedModalStack } from "../../../useModalManager-B5E0Qeku.mjs";
const useModal = (id = void 0) => {
  const { registry } = useSharedModalStack();
  const instance = getCurrentInstance();
  const findBModal = (component) => {
    if (!component.parent) {
      return null;
    }
    if (component.parent.type.__name === "BModal") {
      return component.parent;
    }
    return findBModal(component.parent);
  };
  const modalComponent = computed(() => {
    var _a;
    const resolvedId = toValue(id);
    if (resolvedId) {
      if (!registry) return null;
      for (const [, modal2] of registry.value) {
        if (((_a = modal2.exposed) == null ? void 0 : _a.id.value) === resolvedId) {
          return modal2;
        }
      }
      return null;
    }
    if (!instance) {
      return null;
    }
    return findBModal(instance);
  });
  const modal = computed(() => {
    var _a;
    return (_a = modalComponent.value) == null ? void 0 : _a.proxy;
  });
  return {
    show() {
      var _a, _b;
      (_b = (_a = modalComponent.value) == null ? void 0 : _a.exposed) == null ? void 0 : _b.show();
    },
    hide(trigger = "") {
      var _a, _b;
      (_b = (_a = modalComponent.value) == null ? void 0 : _a.exposed) == null ? void 0 : _b.hide(trigger);
    },
    modal
  };
};
export {
  useModal
};
//# sourceMappingURL=index.mjs.map
