import { ref, toRef, markRaw, watch } from "vue";
import { m as modalControllerPluginKey } from "../../../keys-DuZp76_V.mjs";
const modalControllerPlugin = {
  install(app) {
    const modals = ref(/* @__PURE__ */ new Map());
    const buildPromise = () => {
      let resolveFunc = () => {
      };
      const promise = new Promise((resolve) => {
        resolveFunc = resolve;
      });
      return {
        value: promise,
        resolve: resolveFunc
      };
    };
    const buildPrereqs = () => [buildPromise(), Symbol(), true];
    const show = (obj = {}) => {
      const resolvedProps = toRef(obj.props);
      const [_promise, _self, _modelValue] = buildPrereqs();
      modals.value.set(_self, {
        component: !obj.component ? void 0 : markRaw(obj.component),
        props: { ...resolvedProps.value, _isConfirm: false, _promise, _modelValue }
      });
      watch(resolvedProps, (newValue) => {
        const previous = modals.value.get(_self);
        if (!previous) return;
        modals.value.set(_self, {
          component: !obj.component ? void 0 : markRaw(obj.component),
          props: { ...previous.props, ...newValue }
        });
      });
      return _promise.value;
    };
    const confirm = (obj = {}) => {
      const resolvedProps = toRef(obj.props);
      const [_promise, _self, _modelValue] = buildPrereqs();
      modals.value.set(_self, {
        component: !obj.component ? void 0 : markRaw(obj.component),
        props: { ...resolvedProps.value, _isConfirm: true, _promise, _modelValue }
      });
      watch(resolvedProps, (newValue) => {
        const previous = modals.value.get(_self);
        if (!previous) return;
        modals.value.set(_self, {
          component: !obj.component ? void 0 : markRaw(obj.component),
          props: { ...previous.props, ...newValue }
        });
      });
      return _promise.value;
    };
    const leave = (self) => {
      const modal = modals.value.get(self);
      if (!(modal == null ? void 0 : modal.props)) return;
      modal.props = {
        ...modal.props,
        _modelValue: false
      };
    };
    const remove = (self) => {
      modals.value.delete(self);
    };
    app.provide(modalControllerPluginKey, {
      modals,
      remove,
      show,
      confirm,
      leave
    });
  }
};
export {
  modalControllerPlugin
};
//# sourceMappingURL=index.mjs.map
