import { ref, toRef, watch, markRaw } from "vue";
import { p as popoverPluginKey } from "../../../keys-DuZp76_V.mjs";
const popoverPlugin = {
  install(app) {
    const popovers = ref(/* @__PURE__ */ new Map());
    const show = (obj) => {
      const resolvedProps = toRef(obj.props);
      const _self = Symbol();
      watch(
        obj.ref,
        (newValue) => {
          if (!newValue) {
            popovers.value.delete(_self);
          } else {
            popovers.value.set(_self, {
              component: !obj.component ? void 0 : markRaw(obj.component),
              props: { ...resolvedProps.value, _reference: newValue, _modelValue: false }
            });
          }
        },
        { immediate: true }
      );
      watch(resolvedProps, (newValue) => {
        const previous = popovers.value.get(_self);
        if (!previous) return;
        popovers.value.set(_self, {
          component: !obj.component ? void 0 : markRaw(obj.component),
          props: { ...previous.props, ...newValue }
        });
      });
      return _self;
    };
    const remove = (self) => {
      popovers.value.delete(self);
    };
    const set = (self, val) => {
      const popover = popovers.value.get(self);
      if (!(popover == null ? void 0 : popover.props)) return;
      popover.props = {
        ...popover.props,
        ...val
      };
    };
    app.provide(popoverPluginKey, {
      popovers,
      show,
      remove,
      set
    });
  }
};
export {
  popoverPlugin
};
//# sourceMappingURL=index.mjs.map
