import { ref, toRef, watch, markRaw } from "vue";
import { a as tooltipPluginKey } from "../../../keys-DuZp76_V.mjs";
const tooltipPlugin = {
  install(app) {
    const tooltips = ref(/* @__PURE__ */ new Map());
    const show = (obj) => {
      const resolvedProps = toRef(obj.props);
      const _self = Symbol();
      watch(
        obj.ref,
        (newValue) => {
          if (!newValue) {
            tooltips.value.delete(_self);
          } else {
            tooltips.value.set(_self, {
              component: !obj.component ? void 0 : markRaw(obj.component),
              props: { ...resolvedProps.value, _modelValue: false, _reference: newValue }
            });
          }
        },
        {
          immediate: true
        }
      );
      watch(resolvedProps, (newValue) => {
        const previous = tooltips.value.get(_self);
        if (!previous) return;
        tooltips.value.set(_self, {
          component: !obj.component ? void 0 : markRaw(obj.component),
          props: { ...previous.props, ...newValue }
        });
      });
      return _self;
    };
    const remove = (self) => {
      tooltips.value.delete(self);
    };
    const set = (self, val) => {
      const tip = tooltips.value.get(self);
      if (!(tip == null ? void 0 : tip.props)) return;
      tip.props = {
        ...tip.props,
        ...val
      };
    };
    app.provide(tooltipPluginKey, {
      tooltips,
      show,
      remove,
      set
    });
  }
};
export {
  tooltipPlugin
};
//# sourceMappingURL=index.mjs.map
