import type * as ExportedComponents from '../components';
import type * as ExportedDirectives from '../directives';
import type * as ExportedComposables from '../composables';
import type * as ComponentProps from './ComponentProps';
export type ComponentType = keyof typeof ExportedComponents;
export type DirectiveType = keyof typeof ExportedDirectives;
export type ComposableType = keyof typeof ExportedComposables;
export declare const componentsWithExternalPath: {
    readonly BAccordion: "/components/BAccordion";
    readonly BAccordionItem: "/components/BAccordion";
    readonly BAlert: "/components/BAlert";
    readonly BAvatar: "/components/BAvatar";
    readonly BAvatarGroup: "/components/BAvatar";
    readonly BBadge: "/components/BBadge";
    readonly BBreadcrumb: "/components/BBreadcrumb";
    readonly BBreadcrumbItem: "/components/BBreadcrumb";
    readonly BButton: "/components/BButton";
    readonly BButtonGroup: "/components/BButton";
    readonly BButtonToolbar: "/components/BButton";
    readonly BCloseButton: "/components/BButton";
    readonly BCard: "/components/BCard";
    readonly BCardBody: "/components/BCard";
    readonly BCardFooter: "/components/BCard";
    readonly BCardGroup: "/components/BCard";
    readonly BCardHeader: "/components/BCard";
    readonly BCardImg: "/components/BCard";
    readonly BCardSubtitle: "/components/BCard";
    readonly BCardText: "/components/BCard";
    readonly BCardTitle: "/components/BCard";
    readonly BCarousel: "/components/BCarousel";
    readonly BCarouselSlide: "/components/BCarousel";
    readonly BCol: "/components/BContainer";
    readonly BCollapse: "/components/BCollapse";
    readonly BContainer: "/components/BContainer";
    readonly BDropdown: "/components/BDropdown";
    readonly BDropdownDivider: "/components/BDropdown";
    readonly BDropdownForm: "/components/BDropdown";
    readonly BDropdownGroup: "/components/BDropdown";
    readonly BDropdownHeader: "/components/BDropdown";
    readonly BDropdownItem: "/components/BDropdown";
    readonly BDropdownItemButton: "/components/BDropdown";
    readonly BDropdownText: "/components/BDropdown";
    readonly BForm: "/components/BForm";
    readonly BFormCheckbox: "/components/BFormCheckbox";
    readonly BFormCheckboxGroup: "/components/BFormCheckbox";
    readonly BFormDatalist: "/components/BForm";
    readonly BFormFile: "/components/BFormFile";
    readonly BFormFloatingLabel: "/components/BForm";
    readonly BFormGroup: "/components/BFormGroup";
    readonly BFormInput: "/components/BFormInput";
    readonly BFormInvalidFeedback: "/components/BForm";
    readonly BFormRadio: "/components/BFormRadio";
    readonly BFormRadioGroup: "/components/BFormRadio";
    readonly BFormRow: "/components/BForm";
    readonly BFormSelect: "/components/BFormSelect";
    readonly BFormSelectOption: "/components/BFormSelect";
    readonly BFormSelectOptionGroup: "/components/BFormSelect";
    readonly BFormSpinbutton: "/components/BFormSpinbutton";
    readonly BFormTag: "/components/BFormTags";
    readonly BFormTags: "/components/BFormTags";
    readonly BFormText: "/components/BForm";
    readonly BFormTextarea: "/components/BFormTextarea";
    readonly BFormValidFeedback: "/components/BForm";
    readonly BImg: "/components/BImg";
    readonly BInput: "/components/BFormInput";
    readonly BInputGroup: "/components/BInputGroup";
    readonly BInputGroupText: "/components/BInputGroup";
    readonly BListGroup: "/components/BListGroup";
    readonly BListGroupItem: "/components/BListGroup";
    readonly BModal: "/components/BModal";
    readonly BModalOrchestrator: "/components/BModal";
    readonly BNav: "/components/BNav";
    readonly BNavForm: "/components/BNav";
    readonly BNavItem: "/components/BNav";
    readonly BNavItemDropdown: "/components/BNav";
    readonly BNavText: "/components/BNav";
    readonly BNavbar: "/components/BNavbar";
    readonly BNavbarBrand: "/components/BNavbar";
    readonly BNavbarNav: "/components/BNavbar";
    readonly BNavbarToggle: "/components/BNavbar";
    readonly BOffcanvas: "/components/BOffcanvas";
    readonly BOverlay: "/components/BOverlay";
    readonly BPagination: "/components/BPagination";
    readonly BPlaceholder: "/components/BPlaceholder";
    readonly BPlaceholderButton: "/components/BPlaceholder";
    readonly BPlaceholderCard: "/components/BPlaceholder";
    readonly BPlaceholderTable: "/components/BPlaceholder";
    readonly BPlaceholderWrapper: "/components/BPlaceholder";
    readonly BPopover: "/components/BPopover";
    readonly BProgress: "/components/BProgress";
    readonly BRow: "/components/BContainer";
    readonly BSpinner: "/components/BSpinner";
    readonly BTab: "/components/BTabs";
    readonly BTabs: "/components/BTabs";
    readonly BToast: "/components/BToast";
    readonly BToastOrchestrator: "/components/BToast";
    readonly BTooltip: "/components/BTooltip";
    readonly BLink: "/components/BLink";
    readonly BProgressBar: "/components/BProgress";
    readonly BTableSimple: "/components/BTable";
    readonly BTableLite: "/components/BTable";
    readonly BTable: "/components/BTable";
    readonly BTbody: "/components/BTable";
    readonly BTd: "/components/BTable";
    readonly BTh: "/components/BTable";
    readonly BThead: "/components/BTable";
    readonly BTfoot: "/components/BTable";
    readonly BTr: "/components/BTable";
    readonly BPopoverOrchestrator: "/components/BPopover";
    readonly BTooltipOrchestrator: "/components/BTooltip";
};
export declare const componentNames: readonly ("BAccordion" | "BAccordionItem" | "BAlert" | "BAvatar" | "BAvatarGroup" | "BBadge" | "BBreadcrumb" | "BBreadcrumbItem" | "BButton" | "BButtonGroup" | "BButtonToolbar" | "BCloseButton" | "BCard" | "BCardBody" | "BCardFooter" | "BCardGroup" | "BCardHeader" | "BCardImg" | "BCardSubtitle" | "BCardText" | "BCardTitle" | "BCarousel" | "BCarouselSlide" | "BCollapse" | "BCol" | "BContainer" | "BRow" | "BDropdown" | "BDropdownDivider" | "BDropdownForm" | "BDropdownGroup" | "BDropdownHeader" | "BDropdownItem" | "BDropdownItemButton" | "BDropdownText" | "BForm" | "BFormDatalist" | "BFormFloatingLabel" | "BFormInvalidFeedback" | "BFormRow" | "BFormText" | "BFormValidFeedback" | "BFormCheckbox" | "BFormCheckboxGroup" | "BFormFile" | "BFormGroup" | "BFormInput" | "BInput" | "BFormRadio" | "BFormRadioGroup" | "BFormSelect" | "BFormSelectOption" | "BFormSelectOptionGroup" | "BFormSpinbutton" | "BFormTags" | "BFormTag" | "BFormTextarea" | "BImg" | "BInputGroup" | "BInputGroupText" | "BLink" | "BListGroup" | "BListGroupItem" | "BModal" | "BModalOrchestrator" | "BNav" | "BNavForm" | "BNavItem" | "BNavItemDropdown" | "BNavText" | "BNavbar" | "BNavbarBrand" | "BNavbarNav" | "BNavbarToggle" | "BOffcanvas" | "BOverlay" | "BPagination" | "BPlaceholder" | "BPlaceholderButton" | "BPlaceholderCard" | "BPlaceholderTable" | "BPlaceholderWrapper" | "BPopover" | "BPopoverOrchestrator" | "BProgress" | "BProgressBar" | "BSpinner" | "BTable" | "BTableLite" | "BTableSimple" | "BTbody" | "BTd" | "BTfoot" | "BTh" | "BThead" | "BTr" | "BTab" | "BTabs" | "BToast" | "BToastOrchestrator" | "BTooltip" | "BTooltipOrchestrator")[];
export declare const directivesWithExternalPath: {
    readonly vBColorMode: "/directives/BColorMode";
    readonly vBModal: "/directives/BModal";
    readonly vBPopover: "/directives/BPopover";
    readonly vBScrollspy: "/directives/BScrollspy";
    readonly vBToggle: "/directives/BToggle";
    readonly vBTooltip: "/directives/BTooltip";
};
export declare const directiveNames: readonly ("vBToggle" | "vBColorMode" | "vBModal" | "vBPopover" | "vBScrollspy" | "vBTooltip")[];
export declare const composablesWithExternalPath: {
    readonly useBreadcrumb: "/composables/useBreadcrumb";
    readonly useColorMode: "/composables/useColorMode";
    readonly useModal: "/composables/useModal";
    readonly useModalController: "/composables/useModalController";
    readonly useScrollspy: "/composables/useScrollspy";
    readonly useToast: "/composables/useToast";
    readonly usePopover: "/composables/usePopover";
    readonly useTooltip: "/composables/useTooltip";
};
export declare const composableNames: readonly ("useBreadcrumb" | "useColorMode" | "useModal" | "useModalController" | "useScrollspy" | "useToast" | "useTooltip" | "usePopover")[];
export type ConfigurationOption<T extends string> = Partial<Record<T, boolean>> & {
    all: boolean;
};
export interface BootstrapVueOptions {
    /**
     * @default true
     */
    breadcrumb?: boolean;
    /**
     * @default true
     */
    modalController?: boolean;
    /**
     * @default true
     */
    modalManager?: boolean;
    /**
     * @default true
     */
    rtl?: boolean | {
        /**
         * @default false
         */
        rtlInitial: boolean;
        /**
         * @default undefined
         */
        localeInitial: string | undefined;
    };
    /**
     * @default true
     */
    toast?: boolean;
    components?: Partial<BvnComponentProps & {
        /**
         * @hint Globally sets all props with the matching name
         */
        global: Record<string, any>;
    }>;
    tooltip?: boolean;
    popover?: boolean;
}
type UnmappedComponentProps<BFormSelectOption = any, BTableLite = any, BTable = any> = {
    BLink: ComponentProps.BLinkProps;
    BAccordion: ComponentProps.BAccordionProps;
    BDropdownDivider: ComponentProps.BDropdownDividerProps;
    BDropdownGroup: ComponentProps.BDropdownGroupProps;
    BDropdownItem: ComponentProps.BDropdownItemProps;
    BDropdownItemButton: ComponentProps.BDropdownItemButtonProps;
    BDropdownText: ComponentProps.BDropdownTextProps;
    BFormFloatingLabel: ComponentProps.BFormFloatingLabelProps;
    BFormRow: ComponentProps.BFormRowProps;
    BFormText: ComponentProps.BFormTextProps;
    BFormCheckbox: ComponentProps.BFormCheckboxProps;
    BFormCheckboxGroup: ComponentProps.BFormCheckboxGroupProps;
    BFormDatalist: ComponentProps.BFormDatalistProps;
    BFormFile: ComponentProps.BFormFileProps;
    BFormInput: ComponentProps.BFormInputProps;
    BFormRadio: ComponentProps.BFormRadioProps;
    BFormRadioGroup: ComponentProps.BFormRadioGroupProps;
    BFormSelect: ComponentProps.BFormSelectProps;
    BFormSelectOption: ComponentProps.BFormSelectOptionProps<BFormSelectOption>;
    BFormSelectOptionGroup: ComponentProps.BFormSelectOptionGroupProps;
    BFormSpinbutton: ComponentProps.BFormSpinbuttonProps;
    BFormTag: ComponentProps.BFormTagProps;
    BFormTags: ComponentProps.BFormTagsProps;
    BFormTextarea: ComponentProps.BFormTextareaProps;
    BInputGroup: ComponentProps.BInputGroupProps;
    BInputGroupText: ComponentProps.BInputGroupTextProps;
    BListGroup: ComponentProps.BListGroupProps;
    BListGroupItem: ComponentProps.BListGroupItemProps;
    BModalOrchestrator: ComponentProps.BModalOrchestratorProps;
    BNav: ComponentProps.BNavProps;
    BNavForm: ComponentProps.BNavFormProps;
    BNavItem: ComponentProps.BNavItemProps;
    BNavText: ComponentProps.BNavTextProps;
    BNavbar: ComponentProps.BNavbarProps;
    BNavbarBrand: ComponentProps.BNavbarBrandProps;
    BNavbarNav: ComponentProps.BNavbarNavProps;
    BNavbarToggle: ComponentProps.BNavbarToggleProps;
    BOffcanvas: ComponentProps.BOffcanvasProps;
    BOverlay: ComponentProps.BOverlayProps;
    BPagination: ComponentProps.BPaginationProps;
    BPlaceholder: ComponentProps.BPlaceholderProps;
    BPlaceholderButton: ComponentProps.BPlaceholderButtonProps;
    BPlaceholderCard: ComponentProps.BPlaceholderCardProps;
    BPlaceholderTable: ComponentProps.BPlaceholderTableProps;
    BPlaceholderWrapper: ComponentProps.BPlaceholderWrapperProps;
    BProgress: ComponentProps.BProgressProps;
    BTab: ComponentProps.BTabProps;
    BTabs: ComponentProps.BTabsProps;
    BToastOrchestrator: ComponentProps.BToastOrchestratorProps;
    BCollapse: ComponentProps.BCollapseProps;
    BContainer: ComponentProps.BContainerProps;
    BSpinner: ComponentProps.BSpinnerProps;
    BAccordionItem: ComponentProps.BAccordionItemProps;
    BAlert: ComponentProps.BAlertProps;
    BAvatar: ComponentProps.BAvatarProps;
    BAvatarGroup: ComponentProps.BAvatarGroupProps;
    BBadge: ComponentProps.BBadgeProps;
    BBreadcrumb: ComponentProps.BBreadcrumbProps;
    BBreadcrumbItem: ComponentProps.BBreadcrumbItemProps;
    BButton: ComponentProps.BButtonProps;
    BButtonGroup: ComponentProps.BButtonGroupProps;
    BButtonToolbar: ComponentProps.BButtonToolbarProps;
    BCloseButton: ComponentProps.BCloseButtonProps;
    BCard: ComponentProps.BCardProps;
    BCardBody: ComponentProps.BCardBodyProps;
    BCardGroup: ComponentProps.BCardGroupProps;
    BCardSubtitle: ComponentProps.BCardSubtitleProps;
    BCardText: ComponentProps.BCardTextProps;
    BCardTitle: ComponentProps.BCardTitleProps;
    BCarousel: ComponentProps.BCarouselProps;
    BCarouselSlide: ComponentProps.BCarouselSlideProps;
    BTransition: ComponentProps.BTransitionProps;
    BImg: ComponentProps.BImgProps;
    BForm: ComponentProps.BFormProps;
    BTableSimple: ComponentProps.BTableSimpleProps;
    BTableLite: ComponentProps.BTableLiteProps<BTableLite>;
    BTable: ComponentProps.BTableProps<BTable>;
    BTr: ComponentProps.BTrProps;
    BThead: ComponentProps.BTheadProps;
    BTfoot: ComponentProps.BTfootProps;
    BTd: ComponentProps.BTdProps;
    BTbody: ComponentProps.BTbodyProps;
    BTh: ComponentProps.BThProps;
    BProgressBar: ComponentProps.BProgressBarProps;
    BInputGroupAddon: ComponentProps.BInputGroupAddonProps;
    BDropdown: ComponentProps.BDropdownProps;
    BToast: ComponentProps.BToastProps;
    BPopover: ComponentProps.BPopoverProps;
    BTooltip: ComponentProps.BTooltipProps;
    BModal: ComponentProps.BModalProps;
    BCardFooter: ComponentProps.BCardHeadFootProps;
    BCardHeader: ComponentProps.BCardHeadFootProps;
    BCardImg: ComponentProps.BCardImgProps;
    BCol: ComponentProps.BColProps;
    BDropdownForm: never;
    BDropdownHeader: never;
    BFormInvalidFeedback: ComponentProps.BFormFeedbackSharedProps;
    BFormValidFeedback: ComponentProps.BFormFeedbackSharedProps;
    BFormGroup: any;
    BNavItemDropdown: ComponentProps.BDropdownProps;
    BRow: ComponentProps.BRowProps;
    BInput: ComponentProps.BFormInputProps;
    BTooltipOrchestrator: never;
    BPopoverOrchestrator: never;
};
export type BvnComponentProps = {
    [K in ComponentType]: UnmappedComponentProps[K];
};
export {};
