import { k as useTimestamp, l as useElementHover } from "./index-DngH9Pjm.mjs";
import { readonly, toRef, ref, computed, watch, toValue } from "vue";
const useCountdown = (length, interval, timestampOpts = {}) => {
  const resolvedLength = readonly(toRef(length));
  const isPaused = ref(false);
  const target = ref(Date.now() + resolvedLength.value);
  const { isActive, pause, resume, timestamp } = useTimestamp({
    interval,
    controls: true,
    callback: (v) => {
      if (v >= target.value) {
        isPaused.value = false;
        pause();
      }
    },
    ...timestampOpts
  });
  const value = computed(() => target.value - timestamp.value);
  const restart = () => {
    target.value = Date.now() + resolvedLength.value;
    resume();
  };
  watch(resolvedLength, () => {
    restart();
  });
  const myPause = () => {
    isPaused.value = true;
    pause();
  };
  const myResume = () => {
    isPaused.value = false;
    const remainingTime = target.value - timestamp.value;
    target.value = Date.now() + remainingTime;
    resume();
  };
  const stop = () => {
    pause();
    timestamp.value = target.value;
    isPaused.value = false;
  };
  return {
    isActive: readonly(isActive),
    isPaused: readonly(isPaused),
    stop,
    pause: myPause,
    resume: myResume,
    restart,
    value
  };
};
const useCountdownHover = (element, props, actions) => {
  const isHovering = useElementHover(element);
  const onMouseEnter = () => {
    if (toValue(props).noHoverPause) return;
    actions.pause();
  };
  const onMouseLeave = () => {
    if (toValue(props).noResumeOnHoverLeave) return;
    actions.resume();
  };
  watch(isHovering, (newValue) => {
    if (newValue) {
      onMouseEnter();
      return;
    }
    onMouseLeave();
  });
  return {
    isHovering
  };
};
export {
  useCountdownHover as a,
  useCountdown as u
};
//# sourceMappingURL=useCountdownHover-Ds0unFZR.mjs.map
