import { computed, toValue, readonly, toRef } from "vue";
import { u as useAriaInvalid } from "./useAriaInvalid-BTUbGj3Y.mjs";
import { u as useStateClass } from "./useStateClass-BGbSLWFN.mjs";
const getClasses = (items) => computed(() => {
  const resolvedItems = toValue(items);
  return {
    "form-check": resolvedItems.plain === false && resolvedItems.button === false && resolvedItems.hasDefaultSlot,
    "form-check-reverse": resolvedItems.reverse === true,
    "form-check-inline": resolvedItems.inline === true,
    "form-switch": resolvedItems.switch === true,
    [`form-control-${resolvedItems.size}`]: resolvedItems.size !== void 0 && resolvedItems.size !== "md" && resolvedItems.button === false
  };
});
const getInputClasses = (items) => {
  const resolvedItems = readonly(toRef(items));
  const stateClass = useStateClass(() => resolvedItems.value.state ?? null);
  return computed(() => [
    stateClass.value,
    {
      "form-check-input": resolvedItems.value.plain === false && resolvedItems.value.button === false,
      "btn-check": resolvedItems.value.button === true
    }
  ]);
};
const getLabelClasses = (items) => computed(() => {
  const resolvedItems = toValue(items);
  return {
    "form-check-label": resolvedItems.plain === false && resolvedItems.button === false,
    "btn": resolvedItems.button === true,
    [`btn-${resolvedItems.buttonVariant}`]: resolvedItems.button === true && resolvedItems.buttonVariant !== void 0 && resolvedItems.buttonVariant !== null,
    [`btn-${resolvedItems.size}`]: resolvedItems.button && resolvedItems.size && resolvedItems.size !== "md"
  };
});
const getGroupAttr = (items) => {
  const resolvedItems = readonly(toRef(items));
  const computedAriaInvalid = useAriaInvalid(
    () => resolvedItems.value.ariaInvalid,
    () => resolvedItems.value.state
  );
  return computed(() => ({
    "aria-invalid": computedAriaInvalid.value,
    "aria-required": resolvedItems.value.required === true ? true : void 0
  }));
};
const getGroupClasses = (items) => computed(() => {
  const resolvedItems = toValue(items);
  return {
    "was-validated": resolvedItems.validated === true,
    "btn-group": resolvedItems.buttons === true && resolvedItems.stacked === false,
    "btn-group-vertical": resolvedItems.stacked === true && resolvedItems.buttons === true,
    [`btn-group-${resolvedItems.size}`]: resolvedItems.size !== void 0
  };
});
export {
  getInputClasses as a,
  getLabelClasses as b,
  getGroupAttr as c,
  getGroupClasses as d,
  getClasses as g
};
//# sourceMappingURL=useFormCheck-Bcx8Ea7M.mjs.map
