import { defineComponent, openBlock, createElementBlock, unref, renderSlot, computed, toValue } from "vue";
import { u as useDefaults } from "./useDefaults-BuoSLvNO.mjs";
import { g as get } from "./object-DIbMZaP9.mjs";
const _hoisted_1 = ["value", "disabled"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormSelectOption",
  props: {
    disabled: { type: Boolean, default: false },
    value: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BFormSelectOption");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("option", {
        value: unref(props).value,
        disabled: unref(props).disabled
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 8, _hoisted_1);
    };
  }
});
const useFormSelect = (options, props) => {
  const isComplex = (option) => typeof option === "object" && option !== null && "label" in option;
  const normalizeOption = (option) => {
    const propsValue = toValue(props);
    if (typeof option === "string") {
      return { value: option, text: option };
    }
    if (typeof option === "number") {
      return { value: option, text: `${option}` };
    }
    if (option instanceof Date) {
      return { value: option, text: option.toLocaleString() };
    }
    const value = get(option, propsValue.valueField);
    const text = get(option, propsValue.textField);
    const html = get(option, propsValue.htmlField);
    const disabled = get(option, propsValue.disabledField);
    const opts = propsValue.optionsField ? get(option, propsValue.optionsField) : void 0;
    if (opts !== void 0) {
      return {
        label: get(option, propsValue.labelField) || text,
        options: opts
      };
    }
    return {
      value,
      text,
      html,
      disabled
    };
  };
  const normalizeOptions = (opts) => opts.map((option) => normalizeOption(option));
  const normalizedOptions = computed(() => normalizeOptions(toValue(options)));
  return { normalizedOptions, isComplex };
};
export {
  _sfc_main as _,
  useFormSelect as u
};
//# sourceMappingURL=useFormSelect-CPaZDkF4.mjs.map
