import { defineComponent, computed, createBlock, openBlock, resolveDynamicComponent, mergeProps, unref, withCtx, createVNode, renderSlot } from "vue";
import { u as useBLinkHelper, _ as _sfc_main$1 } from "./BLink.vue_vue_type_script_setup_true_lang-Crq1j_mE.mjs";
import { u as useColorVariantClasses } from "./useColorVariantClasses-ZDE19TZw.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { _ as _sfc_main$2 } from "./ConditionalWrapper.vue_vue_type_script_lang-BLT72l8w.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BBadge",
  props: {
    dotIndicator: { type: Boolean, default: false },
    pill: { type: Boolean, default: false },
    placement: { default: void 0 },
    tag: { default: "span" },
    active: { type: Boolean, default: void 0 },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: void 0 },
    href: { default: void 0 },
    icon: { type: Boolean, default: void 0 },
    noRel: { type: Boolean },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    prefetch: { type: Boolean },
    prefetchOn: {},
    noPrefetch: { type: Boolean },
    prefetchedClass: {},
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: void 0 },
    variant: { default: "secondary" },
    bgVariant: { default: null },
    textVariant: { default: null }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BBadge");
    const { computedLink, computedLinkProps } = useBLinkHelper(props, [
      "active",
      "activeClass",
      "append",
      "disabled",
      "href",
      "rel",
      "replace",
      "routerComponentName",
      "target",
      "to",
      "opacity",
      "opacityHover",
      "underlineVariant",
      "underlineOffset",
      "underlineOffsetHover",
      "underlineOpacity",
      "underlineOpacityHover",
      "icon"
    ]);
    const computedTag = computed(() => computedLink.value ? _sfc_main$1 : props.tag);
    const placementClasses = computed(() => {
      const pos = props.placement ?? (props.dotIndicator ? "top-end" : void 0);
      return [
        "position-absolute",
        "translate-middle",
        {
          "start-0 top-0": pos === "top-start",
          "start-0 top-50": pos === "start",
          "start-0 top-100": pos === "bottom-start",
          "start-50 top-0": pos === "top",
          "start-50 top-100": pos === "bottom",
          "start-100 top-0": pos === "top-end",
          "start-100 top-50": pos === "end",
          "start-100 top-100": pos === "bottom-end"
        }
      ];
    });
    const colorClasses = useColorVariantClasses(props);
    const computedClasses = computed(() => [
      colorClasses.value,
      props.placement !== void 0 || props.dotIndicator === true ? placementClasses.value : void 0,
      {
        "active": props.active,
        "disabled": props.disabled,
        "rounded-pill": props.pill,
        "p-2 border border-light rounded-circle": props.dotIndicator,
        "text-decoration-none": computedLink.value
      }
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(computedTag.value), mergeProps({
        class: ["badge", computedClasses.value]
      }, unref(computedLinkProps)), {
        default: withCtx(() => [
          createVNode(_sfc_main$2, mergeProps({
            skip: unref(props).dotIndicator !== true,
            tag: "span"
          }, unref(props).dotIndicator ? { class: "visually-hidden" } : {}), {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            _: 3
          }, 16, ["skip"])
        ]),
        _: 3
      }, 16, ["class"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BBadge.vue_vue_type_script_setup_true_lang-Dy7CqA47.mjs.map
