import { defineComponent, computed, createElementBlock, openBlock, normalizeClass, createBlock, resolveDynamicComponent, mergeProps, withCtx, renderSlot, createTextVNode, toDisplayString, unref, createElementVNode, Fragment, renderList } from "vue";
import { useBreadcrumb } from "./src/composables/useBreadcrumb/index.mjs";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { p as pick } from "./object-0ALvRU0O.mjs";
import { _ as _sfc_main$2 } from "./BLink.vue_vue_type_script_setup_true_lang-Crq1j_mE.mjs";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BBreadcrumbItem",
  props: {
    ariaCurrent: { default: "location" },
    text: { default: void 0 },
    active: { type: Boolean, default: false },
    activeClass: { default: void 0 },
    disabled: { type: Boolean, default: void 0 },
    exactActiveClass: { default: void 0 },
    href: { default: void 0 },
    icon: { type: Boolean, default: void 0 },
    noRel: { type: Boolean },
    opacity: { default: void 0 },
    opacityHover: { default: void 0 },
    prefetch: { type: Boolean },
    prefetchOn: {},
    noPrefetch: { type: Boolean },
    prefetchedClass: {},
    rel: { default: void 0 },
    replace: { type: Boolean, default: void 0 },
    routerComponentName: { default: void 0 },
    stretched: { type: Boolean, default: false },
    target: { default: void 0 },
    to: { default: void 0 },
    underlineOffset: { default: void 0 },
    underlineOffsetHover: { default: void 0 },
    underlineOpacity: { default: void 0 },
    underlineOpacityHover: { default: void 0 },
    underlineVariant: { default: void 0 },
    variant: { default: void 0 }
  },
  emits: ["click"],
  setup(__props, { emit: __emit }) {
    const _props = __props;
    const props = useDefaults(_props, "BBreadcrumbItem");
    const emit = __emit;
    const computedClasses = computed(() => ({
      active: props.active
    }));
    const computedTag = computed(() => props.active ? "span" : _sfc_main$2);
    const computedAriaCurrent = computed(() => props.active ? props.ariaCurrent : void 0);
    const computedLinkProps = computed(
      () => computedTag.value !== "span" ? pick(props, [
        "active",
        "activeClass",
        "append",
        "disabled",
        "href",
        "rel",
        "replace",
        "routerComponentName",
        "target",
        "to",
        "variant",
        "opacity",
        "opacityHover",
        "underlineVariant",
        "underlineOffset",
        "underlineOffsetHover",
        "underlineOpacity",
        "underlineOpacityHover",
        "icon"
      ]) : {}
    );
    const clicked = (e) => {
      if (props.disabled || props.active) {
        e.preventDefault();
        e.stopImmediatePropagation();
        return;
      }
      if (!props.disabled) emit("click", e);
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("li", {
        class: normalizeClass(["breadcrumb-item", computedClasses.value])
      }, [
        (openBlock(), createBlock(resolveDynamicComponent(computedTag.value), mergeProps({ "aria-current": computedAriaCurrent.value }, computedLinkProps.value, { onClick: clicked }), {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default", {}, () => [
              createTextVNode(toDisplayString(unref(props).text), 1)
            ])
          ]),
          _: 3
        }, 16, ["aria-current"]))
      ], 2);
    };
  }
});
const _hoisted_1 = ["id"];
const _hoisted_2 = { class: "breadcrumb" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BBreadcrumb",
  props: {
    items: { default: void 0 },
    id: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BBreadcrumb");
    const breadcrumb = useBreadcrumb(() => props.id || null);
    const breadcrumbItemObjects = computed(() => {
      var _a;
      const localItems = props.items || ((_a = breadcrumb.items) == null ? void 0 : _a.value) || [];
      let activeDefined = false;
      const items = localItems.map((item, idx) => {
        if (typeof item === "string") {
          item = { text: item };
          if (idx < localItems.length - 1) item.href = "#";
        }
        if (item.active) activeDefined = true;
        if (!item.active && !activeDefined) {
          item.active = idx + 1 === localItems.length;
        }
        return item;
      });
      return items;
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("nav", {
        id: unref(props).id,
        "aria-label": "breadcrumb"
      }, [
        createElementVNode("ol", _hoisted_2, [
          renderSlot(_ctx.$slots, "prepend"),
          (openBlock(true), createElementBlock(Fragment, null, renderList(breadcrumbItemObjects.value, (item, i) => {
            return openBlock(), createBlock(_sfc_main$1, mergeProps({
              key: i,
              ref_for: true
            }, item), {
              default: withCtx(() => [
                createTextVNode(toDisplayString(item.text), 1)
              ]),
              _: 2
            }, 1040);
          }), 128)),
          renderSlot(_ctx.$slots, "default"),
          renderSlot(_ctx.$slots, "append")
        ])
      ], 8, _hoisted_1);
    };
  }
});
export {
  _sfc_main as _,
  _sfc_main$1 as a
};
//# sourceMappingURL=BBreadcrumb.vue_vue_type_script_setup_true_lang-aab8VaEA.mjs.map
