import { defineComponent, provide, computed, createBlock, openBlock, resolveDynamicComponent, unref, normalizeClass, withCtx, renderSlot, createElementBlock } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { b as buttonGroupKey } from "./keys-CwytVEYF.mjs";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BButtonGroup",
  props: {
    ariaLabel: { default: "Group" },
    size: { default: "md" },
    tag: { default: "div" },
    vertical: { type: Boolean, default: false }
  },
  setup(__props) {
    provide(buttonGroupKey, true);
    const _props = __props;
    const props = useDefaults(_props, "BButtonGroup");
    const computedClasses = computed(() => ({
      "btn-group": !props.vertical,
      [`btn-group-${props.size}`]: props.size !== "md",
      "btn-group-vertical": props.vertical
    }));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        class: normalizeClass(computedClasses.value),
        role: "group",
        "aria-label": unref(props).ariaLabel
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 8, ["class", "aria-label"]);
    };
  }
});
const _hoisted_1 = ["role", "aria-label"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BButtonToolbar",
  props: {
    ariaLabel: { default: "Group" },
    justify: { type: Boolean, default: false },
    role: { default: "toolbar" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BButtonToolbar");
    const computedClasses = computed(() => ({
      "justify-content-between": props.justify
    }));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass([computedClasses.value, "btn-toolbar"]),
        role: unref(props).role,
        "aria-label": unref(props).ariaLabel
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 10, _hoisted_1);
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BButtonToolbar.vue_vue_type_script_setup_true_lang-BSwHiGXg.mjs.map
