import { defineComponent, computed, createBlock, openBlock, resolveDynamicComponent, unref, normalizeClass, withCtx, renderSlot, createTextVNode, toDisplayString } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BCardGroup",
  props: {
    columns: { type: Boolean, default: false },
    deck: { type: Boolean, default: false },
    tag: { default: "div" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BCardGroup");
    const cardTypeClass = computed(
      () => props.deck ? "card-deck" : props.columns ? "card-columns" : "card-group"
    );
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        class: normalizeClass(cardTypeClass.value)
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BCardText",
  props: {
    tag: { default: "p" },
    text: { default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BCardText");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), { class: "card-text" }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString(unref(props).text), 1)
          ])
        ]),
        _: 3
      });
    };
  }
});
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
//# sourceMappingURL=BCardText.vue_vue_type_script_setup_true_lang-DdqzUfNr.mjs.map
