import { defineComponent, computed, createBlock, openBlock, resolveDynamicComponent, unref, normalizeClass, withCtx, renderSlot } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BContainer",
  props: {
    fluid: { type: [Boolean, String], default: false },
    gutterX: { default: void 0 },
    gutterY: { default: void 0 },
    tag: { default: "div" }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BContainer");
    const computedClasses = computed(() => ({
      container: props.fluid === false,
      [`container-fluid`]: props.fluid === true,
      [`container-${props.fluid}`]: typeof props.fluid === "string",
      [`gx-${props.gutterX}`]: props.gutterX !== void 0,
      [`gy-${props.gutterY}`]: props.gutterY !== void 0
    }));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        class: normalizeClass(computedClasses.value)
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 8, ["class"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BContainer.vue_vue_type_script_setup_true_lang-D1yL7duP.mjs.map
