import { defineComponent, mergeModels, computed, useModel, ref, createElementBlock, openBlock, normalizeClass, createCommentVNode, unref, createElementVNode, Fragment, renderList, renderSlot, normalizeStyle, toDisplayString } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
const _hoisted_1 = ["aria-valuemax", "aria-valuenow", "aria-valuetext"];
const _hoisted_2 = ["onClick"];
const _hoisted_3 = { class: "b-form-rating-star" };
const _hoisted_4 = ["width", "height"];
const _hoisted_5 = {
  key: 0,
  d: "M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"
};
const _hoisted_6 = {
  key: 1,
  d: "M5.354 5.119 7.538.792A.52.52 0 0 1 8 .5c.183 0 .366.097.465.292l2.184 4.327 4.898.696A.54.54 0 0 1 16 6.32a.55.55 0 0 1-.17.445l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256a.5.5 0 0 1-.146.05c-.342.06-.668-.254-.6-.642l.83-4.73L.173 6.765a.55.55 0 0 1-.172-.403.6.6 0 0 1 .085-.302.51.51 0 0 1 .37-.245zM8 12.027a.5.5 0 0 1 .232.056l3.686 1.894-.694-3.957a.56.56 0 0 1 .162-.505l2.907-2.77-4.052-.576a.53.53 0 0 1-.393-.288L8.001 2.223 8 2.226z"
};
const _hoisted_7 = {
  key: 2,
  d: "M2.866 14.85c-.078.444.36.791.746.593l4.39-2.256 4.389 2.256c.386.198.824-.149.746-.592l-.83-4.73 3.522-3.356c.33-.314.16-.888-.282-.95l-4.898-.696L8.465.792a.513.513 0 0 0-.927 0L5.354 5.12l-4.898.696c-.441.062-.612.636-.283.95l3.522 3.356-.83 4.73zm4.905-2.767-3.686 1.894.694-3.957a.56.56 0 0 0-.163-.505L1.71 6.745l4.052-.576a.53.53 0 0 0 .393-.288L8 2.223l1.847 3.658a.53.53 0 0 0 .393.288l4.052.575-2.906 2.77a.56.56 0 0 0-.163.506l.694 3.957-3.686-1.894a.5.5 0 0 0-.461 0z"
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormRating",
  props: /* @__PURE__ */ mergeModels({
    color: { default: "" },
    noBorder: { type: Boolean, default: false },
    precision: { default: 0 },
    readonly: { type: Boolean, default: false },
    showClear: { type: Boolean, default: false },
    showValue: { type: Boolean, default: false },
    showValueMax: { type: Boolean, default: false },
    size: { default: "1rem" },
    stars: { default: 5 },
    variant: { default: "" },
    iconFull: {},
    iconHalf: {},
    iconEmpty: {},
    inline: { type: Boolean, default: false }
  }, {
    "modelValue": { default: 0 },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BFormRating");
    const computedClasses = computed(() => ({
      "is-readonly": props.readonly,
      "no-border": props.noBorder,
      "b-form-rating": true,
      "d-inline-block": props.inline,
      "w-100": !props.inline
    }));
    const modelValue = useModel(__props, "modelValue");
    function isIconFull(index) {
      return displayValue.value - index >= 1;
    }
    function isIconHalf(index) {
      const diff = displayValue.value - index;
      return diff >= 0.5 && diff < 1;
    }
    const hoverValue = ref(null);
    const localValue = computed({
      get: () => modelValue.value,
      set: (value) => {
        modelValue.value = value;
      }
    });
    const displayValue = computed(
      () => hoverValue.value !== null ? hoverValue.value : localValue.value
    );
    const clampedStars = computed(() => Math.max(3, props.stars));
    const computedSize = computed(() => {
      if (props.size === "sm") return ".875rem";
      if (props.size === "lg") return "1.25rem";
      return props.size;
    });
    const displayValueText = computed(() => {
      const decimalValue = props.precision > 0 ? roundedValue.value : displayValue.value;
      if (props.showValueMax) {
        return `${decimalValue}/${clampedStars.value}`;
      }
      if (props.showValue) {
        return `${decimalValue}`;
      }
      return "";
    });
    const roundedValue = computed(() => {
      const val = displayValue.value;
      const factor = 10 ** props.precision;
      return Math.round((val + Number.EPSILON) * factor) / factor;
    });
    const iconColors = computed(
      () => Array.from({ length: clampedStars.value }, () => {
        if (props.variant) {
          return { class: `text-${props.variant}`, style: {} };
        }
        if (props.color) {
          return { class: "", style: { color: props.color } };
        }
        return { class: "", style: {} };
      })
    );
    function onKeydown(e) {
      if (props.readonly) return;
      let newValue = localValue.value;
      switch (e.key) {
        case "ArrowRight":
        case "ArrowUp":
          newValue = Math.min(newValue + 1, clampedStars.value);
          break;
        case "ArrowLeft":
        case "ArrowDown":
          newValue = Math.max(newValue - 1, 0);
          break;
        default:
          return;
      }
      e.preventDefault();
      localValue.value = newValue;
    }
    function selectRating(starIndex) {
      if (props.readonly) return;
      const selectedRating = hoverValue.value !== null ? hoverValue.value : starIndex;
      localValue.value = selectedRating;
    }
    function clearRating() {
      hoverValue.value = null;
      localValue.value = 0;
    }
    __expose({
      hoverValue
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(computedClasses.value),
        role: "slider",
        "aria-valuemin": 0,
        "aria-valuemax": clampedStars.value,
        "aria-valuenow": displayValue.value,
        "aria-valuetext": `${displayValue.value} of ${clampedStars.value}`,
        tabindex: "0",
        onKeydown
      }, [
        unref(props).showClear && !unref(props).readonly ? (openBlock(), createElementBlock("span", {
          key: 0,
          class: "clear-button-spacing",
          onClick: clearRating
        }, _cache[0] || (_cache[0] = [
          createElementVNode("svg", {
            viewBox: "0 0 16 16",
            role: "img",
            "aria-label": "x",
            xmlns: "http://www.w3.org/2000/svg",
            class: "clear-icon"
          }, [
            createElementVNode("g", null, [
              createElementVNode("path", { d: "M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708" })
            ])
          ], -1)
        ]))) : createCommentVNode("", true),
        (openBlock(true), createElementBlock(Fragment, null, renderList(clampedStars.value, (starIndex, index) => {
          return openBlock(), createElementBlock("span", {
            key: starIndex,
            class: "star",
            onClick: ($event) => selectRating(starIndex)
          }, [
            renderSlot(_ctx.$slots, "default", {
              starIndex,
              isFilled: isIconFull(index),
              isHalf: isIconHalf(index)
            }, () => [
              createElementVNode("span", _hoisted_3, [
                (openBlock(), createElementBlock("svg", {
                  xmlns: "http://www.w3.org/2000/svg",
                  width: computedSize.value,
                  height: computedSize.value,
                  fill: "currentColor",
                  class: normalizeClass([[iconColors.value[index].class], "star-spacing"]),
                  style: normalizeStyle(iconColors.value[index].style),
                  viewBox: "0 0 16 16"
                }, [
                  isIconFull(index) ? (openBlock(), createElementBlock("path", _hoisted_5)) : isIconHalf(index) ? (openBlock(), createElementBlock("path", _hoisted_6)) : (openBlock(), createElementBlock("path", _hoisted_7))
                ], 14, _hoisted_4))
              ])
            ])
          ], 8, _hoisted_2);
        }), 128)),
        unref(props).showValue || unref(props).showValueMax ? (openBlock(), createElementBlock("span", {
          key: 1,
          style: normalizeStyle({ fontSize: computedSize.value }),
          class: "rating-value-text"
        }, toDisplayString(displayValueText.value), 5)) : createCommentVNode("", true)
      ], 42, _hoisted_1);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BFormRating.vue_vue_type_script_setup_true_lang-D6W_SqxV.mjs.map
