import { ref, computed, toValue, onMounted, nextTick, defineComponent, mergeModels, useModel, useTemplateRef, createElementBlock, openBlock, unref, normalizeStyle, normalizeClass } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { n as normalizeInput, u as useFormInput } from "./useFormInput-Dru3Y8-y.mjs";
import { a as isVisible } from "./dom-BNfqkuY-.mjs";
import { u as useToNumber } from "./index-CYfoub2y.mjs";
const useTextareaResize = (input, {
  maxRows,
  noAutoShrink,
  rows
}) => {
  const height = ref(0);
  const maxRowsNumber = useToNumber(
    computed(() => toValue(maxRows) || NaN),
    {
      method: "parseInt",
      nanToZero: true
    }
  );
  const rowsNumber = useToNumber(rows, {
    method: "parseInt",
    nanToZero: true
  });
  const computedMinRows = computed(() => Math.max(rowsNumber.value || 2, 2));
  const computedMaxRows = computed(() => Math.max(computedMinRows.value, maxRowsNumber.value || 0));
  const computedRows = computed(
    () => computedMinRows.value === computedMaxRows.value ? computedMinRows.value : null
  );
  const handleHeightChange = async () => {
    if (!input.value || !isVisible(input.value)) {
      height.value = null;
      return;
    }
    const computedStyle = getComputedStyle(input.value);
    const lineHeight = Number.parseFloat(computedStyle.lineHeight) || 1;
    const border = (Number.parseFloat(computedStyle.borderTopWidth) || 0) + (Number.parseFloat(computedStyle.borderBottomWidth) || 0);
    const padding = (Number.parseFloat(computedStyle.paddingTop) || 0) + (Number.parseFloat(computedStyle.paddingBottom) || 0);
    const offset = border + padding;
    const minHeight = lineHeight * computedMinRows.value + offset;
    const oldHeight = input.value.style.height || computedStyle.height;
    height.value = "auto";
    await nextTick();
    const { scrollHeight } = input.value;
    height.value = oldHeight;
    await nextTick();
    const contentRows = Math.max((scrollHeight - padding) / lineHeight, 2);
    const rows2 = Math.min(Math.max(contentRows, computedMinRows.value), computedMaxRows.value);
    const newHeight = Math.max(Math.ceil(rows2 * lineHeight + offset), minHeight);
    if (toValue(noAutoShrink) && (Number.parseFloat(oldHeight.toString()) || 0) > newHeight) {
      height.value = oldHeight;
      return;
    }
    height.value = `${newHeight}px`;
  };
  onMounted(handleHeightChange);
  const computedStyles = computed(() => ({
    resize: "none",
    height: typeof height.value === "string" ? height.value : height.value ? `${height.value}px` : void 0
  }));
  return {
    onInput: handleHeightChange,
    computedStyles,
    computedRows
  };
};
const _hoisted_1 = ["id", "name", "form", "value", "disabled", "placeholder", "required", "autocomplete", "readonly", "aria-required", "aria-invalid", "rows", "wrap"];
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BFormTextarea",
  props: /* @__PURE__ */ mergeModels({
    noResize: { type: Boolean, default: false },
    rows: { default: 2 },
    wrap: { default: "soft" },
    noAutoShrink: { type: Boolean, default: false },
    maxRows: { default: void 0 },
    ariaInvalid: { type: [Boolean, String], default: void 0 },
    autocomplete: { default: void 0 },
    autofocus: { type: Boolean, default: false },
    disabled: { type: Boolean, default: false },
    form: { default: void 0 },
    formatter: { type: Function, default: void 0 },
    id: { default: void 0 },
    lazyFormatter: { type: Boolean, default: false },
    list: { default: void 0 },
    name: { default: void 0 },
    placeholder: { default: void 0 },
    plaintext: { type: Boolean, default: false },
    readonly: { type: Boolean, default: false },
    required: { type: Boolean, default: false },
    size: { default: void 0 },
    state: { type: [Boolean, null], default: void 0 },
    debounce: { default: 0 },
    debounceMaxWait: { default: NaN }
  }, {
    "modelValue": {
      default: ""
    },
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const _props = __props;
    const props = useDefaults(_props, "BFormTextarea");
    const [modelValue, modelModifiers] = useModel(__props, "modelValue", {
      set: (v) => normalizeInput(v, modelModifiers)
    });
    const input = useTemplateRef("_input");
    const {
      computedId,
      forceUpdateKey,
      computedAriaInvalid,
      onInput,
      stateClass,
      onChange,
      onBlur,
      focus,
      blur
    } = useFormInput(props, input, modelValue, modelModifiers);
    const computedClasses = computed(() => [
      stateClass.value,
      props.plaintext ? "form-control-plaintext" : "form-control",
      {
        [`form-control-${props.size}`]: !!props.size
      }
    ]);
    const {
      computedStyles: resizeStyles,
      onInput: handleHeightChange,
      computedRows
    } = useTextareaResize(input, {
      maxRows: () => props.maxRows,
      rows: () => props.rows,
      noAutoShrink: () => props.noAutoShrink
    });
    const computedStyles = computed(() => ({
      resize: props.noResize ? "none" : void 0,
      ...props.maxRows || props.noAutoShrink ? resizeStyles.value : void 0
    }));
    __expose({
      blur,
      element: input,
      focus
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("textarea", {
        id: unref(computedId),
        ref: "_input",
        key: unref(forceUpdateKey),
        class: normalizeClass(computedClasses.value),
        name: unref(props).name || void 0,
        form: unref(props).form || void 0,
        value: unref(modelValue) ?? void 0,
        disabled: unref(props).disabled,
        placeholder: unref(props).placeholder,
        required: unref(props).required || void 0,
        autocomplete: unref(props).autocomplete || void 0,
        readonly: unref(props).readonly || unref(props).plaintext,
        "aria-required": unref(props).required || void 0,
        "aria-invalid": unref(computedAriaInvalid),
        rows: unref(computedRows) || 2,
        style: normalizeStyle(computedStyles.value),
        wrap: unref(props).wrap || void 0,
        onInput: _cache[0] || (_cache[0] = (e) => {
          unref(onInput)(e);
          unref(handleHeightChange)();
        }),
        onChange: _cache[1] || (_cache[1] = //@ts-ignore
        (...args) => unref(onChange) && unref(onChange)(...args)),
        onBlur: _cache[2] || (_cache[2] = //@ts-ignore
        (...args) => unref(onBlur) && unref(onBlur)(...args))
      }, null, 46, _hoisted_1);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BFormTextarea.vue_vue_type_script_setup_true_lang-D6MdvTfG.mjs.map
