import { defineComponent, computed, createBlock, openBlock, resolveDynamicComponent, unref, normalizeClass } from "vue";
import { u as useDefaults } from "./useDefaults-2hK8an5B.mjs";
import { u as useRadiusElementClasses } from "./useRadiusElementClasses-DtKYQuWz.mjs";
import { u as useToNumber } from "./index-CYfoub2y.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BImg",
  props: {
    blank: { type: Boolean, default: false },
    blankColor: { default: "transparent" },
    block: { type: Boolean, default: false },
    fluid: { type: Boolean, default: false },
    fluidGrow: { type: Boolean, default: false },
    height: { default: void 0 },
    tag: { default: "img" },
    lazy: { type: Boolean, default: false },
    sizes: { default: void 0 },
    src: { default: void 0 },
    srcset: { default: void 0 },
    thumbnail: { type: Boolean, default: false },
    width: { default: void 0 },
    placement: { default: void 0 },
    rounded: { type: [Boolean, String, Number], default: false },
    roundedTop: { type: [Boolean, String, Number], default: void 0 },
    roundedBottom: { type: [Boolean, String, Number], default: void 0 },
    roundedStart: { type: [Boolean, String, Number], default: void 0 },
    roundedEnd: { type: [Boolean, String, Number], default: void 0 }
  },
  setup(__props) {
    const _props = __props;
    const props = useDefaults(_props, "BImg");
    const heightNumber = useToNumber(() => props.height ?? NaN);
    const widthNumber = useToNumber(() => props.width ?? NaN);
    const radiusElementClasses = useRadiusElementClasses(() => ({
      rounded: props.rounded,
      roundedTop: props.roundedTop,
      roundedBottom: props.roundedBottom,
      roundedStart: props.roundedStart,
      roundedEnd: props.roundedEnd
    }));
    const computedSrcset = computed(
      () => typeof props.srcset === "string" ? props.srcset.split(",").filter((x) => x).join(",") : Array.isArray(props.srcset) ? props.srcset.filter((x) => x).join(",") : void 0
    );
    const computedSizes = computed(
      () => typeof props.sizes === "string" ? props.sizes.split(",").filter((x) => x).join(",") : Array.isArray(props.sizes) ? props.sizes.filter((x) => x).join(",") : void 0
    );
    const computedDimentions = computed(() => {
      const width = Number.isNaN(widthNumber.value) ? void 0 : widthNumber.value;
      const height = Number.isNaN(heightNumber.value) ? void 0 : heightNumber.value;
      if (props.blank) {
        if (width !== void 0 && height === void 0) return { height: width, width };
        if (width === void 0 && height !== void 0) return { height, width: height };
        if (width === void 0 && height === void 0) return { height: 1, width: 1 };
      }
      return {
        width,
        height
      };
    });
    const computedBlankImgSrc = computed(
      () => makeBlankImgSrc(computedDimentions.value.width, computedDimentions.value.height, props.blankColor)
    );
    const computedAlignment = computed(() => ({
      "float-start": props.placement === "start",
      "float-end": props.placement === "end",
      "mx-auto": props.placement === "center"
    }));
    const computedClasses = computed(() => [
      radiusElementClasses.value,
      computedAlignment.value,
      {
        "img-thumbnail": props.thumbnail,
        "img-fluid": props.fluid || props.fluidGrow,
        "w-100": props.fluidGrow,
        "d-block": props.block || props.placement === "center"
      }
    ]);
    const makeBlankImgSrc = (width, height, color) => `data:image/svg+xml;charset=UTF-8,${encodeURIComponent(`<svg width="${width}" height="${height}" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 ${width} ${height}" preserveAspectRatio="none">
    <rect width="100%" height="100%" style="fill:${color};"></rect>
    </svg>`)}`;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(props).tag), {
        class: normalizeClass([computedClasses.value, "b-img"]),
        src: !unref(props).blank ? unref(props).src : computedBlankImgSrc.value,
        width: computedDimentions.value.width || void 0,
        height: computedDimentions.value.height || void 0,
        srcset: !unref(props).blank ? computedSrcset.value : void 0,
        sizes: !unref(props).blank ? computedSizes.value : void 0,
        loading: unref(props).lazy ? "lazy" : "eager"
      }, null, 8, ["class", "src", "width", "height", "srcset", "sizes", "loading"]);
    };
  }
});
export {
  _sfc_main as _
};
//# sourceMappingURL=BImg.vue_vue_type_script_setup_true_lang-BAusIjYG.mjs.map
